/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

/*
 *  VAI/OfoCXiSIOjhCoiM32102񓯊VApj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <sil.h>
#include <sys_config.h>

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND    1u              /* M\R[obN */
#define SIO_ERDY_RCV    2u              /* MʒmR[obN */

/*
 *  VAI/O̊݃nh̃xN^ԍ
 */
#define INHNO_SERIAL_IN		(48 + ((CONSOLE_PORTID-1)*2))
#define INHNO_SERIAL_OUT	(49 + ((CONSOLE_PORTID-1)*2))

#define SIO_TYP(x)			( (x) & 0x000000ff )
#define SIO_TYP_M32RUART	0x00000001

#define SIO_STS(x)			( (x) & 0xffff0000 )
#define SIO_STS_SENDING		0x80000000

typedef struct
{
	int		flags;
	int		port;
	VP_INT	exinf;
} SIOPCB;

//extern SIOPCB siopcb_table[TNUM_PORT];

extern void sio_handler_in(void);
extern void sio_handler_out(void);

/*
 *  VA|[g̏
 */
extern void sio_initialize(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB * sio_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void sio_cls_por(SIOPCB *siopcb);

/*
 *  ꕶM
 */
Inline BOOL
sio_snd_chr(SIOPCB * siopcb, INT chr)
{
	if((siopcb->flags & SIO_STS_SENDING) != 0)
		return FALSE;

	switch(SIO_TYP(siopcb->flags))
	{
	case SIO_TYP_M32RUART:	
		if((sil_reb_mem((void *)(SIOSTS(siopcb->port)+3)) & 0x3) != 0)
		{
			siopcb->flags |= SIO_STS_SENDING;
			sil_wrb_mem((void *)(SIOTXB(siopcb->port)+3), (char)chr);
		} else
			return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


/*
 *  VAI/O|[gւ̕M
 */
extern INT	sio_rcv_chr(SIOPCB *siopcb);

/*
 *  SIO̊݃T[rX[`
 */
extern void	sio_isr(void);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sio_ena_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sio_dis_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  VAI/O|[gւ̕MR[obN
 */
extern void sio_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[gւ̕MR[obN
 */
extern void sio_ierdy_rcv(VP_INT exinf);

/*
 *  VAI/O|[g̕MʒmR[obN
 */
extern void	sio_ercv_chr(ID siopid, INT chr);

#endif /* _HW_SERIAL_H_ */
