/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[ AZuꕔiM3A-2131pj
 */

#define	_MACRO_ONLY

#include <m32rasm.inc>
#include <s_services.h>

/*
 *  ჌x̃^[QbgVXeˑ̏
 *
 *  X^[gAbvW[̒ŁC̏̑OɌĂяoD
 */
	.macro	out		addr, val
		ld24	r0, \addr
		seth	r1, #((\val) >> 16)
		or3		r1, r1, #((\val) & 0xffff)
		st		r1, @r0
	.endm

	.macro	outh	addr, val
		ld24	r0, #(\addr)
		ldi		r1, #(\val)
		sth		r1, @r0
	.endm

	.macro	outb	addr, val
		ld24	r0, #(\addr)
		ldi		r1, #(\val)
		stb		r1, @r0

	.endm

Function hardware_init_hook

	outb	PLLCR+3,   0x1			/* PLLNbNJn */
	out		BSELCR(1), 0x0fffb50f	/* OoXCubNPgpiSDRAMj */

	/* PIO̐ݒ */
	outh	PMOD(0),   0x0100	/* OoXBSEL1gp */
	outh	PMOD(1),   0x1		/* OoXRD/WR */
	outh	PMOD(2),   0x1		/* OoXWS3 */
	outh	PMOD(3),   0x5555	/* OoX */
	outh	PMOD(4),   0x5555	/* OoX */
	outh	PMOD(5),   0x0555	/* I/O */
	outh	PMOD(6),   0x0555	/* I/O */

	outh	SDIR0+2,   0x182

	/* SDRAM */
	ld24	r0, SDIR1+3
	ldi		r1, 1
	stb		r1, @r0
	addi	r0, -2
L1:	ldb		r1, @r0
	bnez	r1, L1					/* DINSTrbgNAƏI */

	outb	SDBR+3, 0x2
	outh	SDRF1+2, 0x0020
	outh	SDMOD(0)+2, 0
	out		SDADR(0), 0x01000042	/* 0x01000000, 32bit, bank 4, 16MB */
	outh	SDTR(0)+2,0x0001

	outb	SDRF1+1, 1				/* tbVL */
	outb	SDER(0)+3, 1			/* SDRAML */
	outb	CPUCLKCR+1, 0x2			/* CPUNbNƂPLLNbNgp */
	rts

Function software_init_hook
	rts

Function vxget_tim
	rts
