/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[iOAKS32pj
 */

#include "jsp_kernel.h"
#include <sil.h>
#include "oaks32.h"

/*
 *  ^[QbgVXeˑ [`
 */

void
sys_initialize(void)
{
	VB * p;
	volatile char ps0, pd6;

	/*
	 * |[g̐ݒ
	 */

	/* |[gP63 TxD0, |[gP62 RxD0  */
	ps0 = sil_reb_mem((VP)TADR_SFR_PS0);
	ps0 |= 0x08;
	ps0 &= ~0x04;
	sil_wrb_mem((VP)TADR_SFR_PS0, ps0);
	pd6 = sil_reb_mem((VP)TADR_SFR_PD6);
	pd6 &= ~0x04;
	pd6 |= 0x08;
	sil_wrb_mem((VP)TADR_SFR_PD6, pd6);

	p = (VB*)TADR_SFR_UART0_BASE;

	/*
	 * UART֘AWX^̐ݒ
	 */
	/* M֎~ */
	sil_wrb_mem((VP)(p+TADR_SFR_UC1_OFFSET), 0x00);

	/* M[hWX^̏ */
	sil_wrb_mem((VP)(p+TADR_SFR_UMR_OFFSET), 0x05);	/* M|hWX^ NbN,*/
				/* 񓯊A8rbgApeBȂA*/
				/* X[vȂ	*/
			/* M䃌WX^̏ */
	sil_wrb_mem((VP)(p+TADR_SFR_UC0_OFFSET), 0x10);	/* M䃌WX^0 NbNf8I */
			/* ]xWX^̏ */
	sil_wrb_mem((VP)(p+TADR_SFR_UBRG_OFFSET), 48);	/* ]xWX^(38400bps)		*/
			/* M䃌WX^̏ */
	sil_wrb_mem((VP)(p+TADR_SFR_UC1_OFFSET), (TBIT_UiC1_TE | TBIT_UiC1_RE));
							/* M䃌WX^P M */

	/*
	 * LED ̏
	 */
	sil_wrb_mem((VP)TADR_SFR_P0, 0xff);	/* |[g0f[^	*/
	sil_wrb_mem((VP)TADR_SFR_PD0, 0xff);	/* |[g0o͐ݒ	*/
}

/*
 *  ^[QbgVXȅI[`
 */

void
sys_exit(void)
{
  while (1);
}

void
sys_putc(char c)
{
	if(c == '\n'){
	    oaks32_putc( '\r' );
	}
    oaks32_putc( c );
}
