/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sfruart.c,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	OAKS16 SFR-UART0,1pVAI/OW[
 */
#include <s_services.h>
#include "oaks16.h"
#include <sfruart.h>

/*
 *  foCXI[ṽgCJEg
 *
 *  500񃊃gC΁A\ɏID
 */
#define	SFRUART_COUNT	500

/*
 * VARg[WX^̐ݒl 
 */
#define	MR_DEF		0x05	/* NbNA񓯊A8rbgApeBȂAX[vȂ */
#define	C0_DEF		0x10	/* RTS/CTSgp, JEg\[Xf1 */
#define	C1_DEF		0x00	/* VAMs */
#define	BRG1_DEF	51		/* 19200bps = 16000000/{(UxBRG+1)*16 */
#define	BRG2_DEF	25		/* 38400bps = 16000000/{(UxBRG+1)*16 */
#define	TB_LEVEL	4		/* M݃x */
#define	RB_LEVEL	5		/* M݃x */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	UH  cntrl;		/* Rg[WX^̔Ԓn */
	UH  hint;		/* ݃WX^̔Ԓn */

	UB  mr_def;		/* ftH[g̐ݒl (MR) */
	UB  c0_def;		/* ftH[g̐ݒl (C0) */
	UB  brg_def;	/* ftH[g̐ݒl (BRG) */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT exinf;	/* g */
	UB     cr1;		/* CR1̐ݒli݋j*/
	UB     tic;		/* M݃x */
} SIOPCB;

/*
 *  VAI/O|[gubN
 *
 *  ID = 1 uart0CID = 2 uart1ɑΉĂD
 */
static const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ TADR_SFR_UART0_BASE, TADR_SFR_INT_BASE, MR_DEF, C0_DEF, BRG1_DEF },
	{ TADR_SFR_UART1_BASE, TADR_SFR_INT_BASE+2, MR_DEF, C0_DEF, BRG1_DEF }
};

/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOhCȍ[`
 */
void
sfruart_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->cr1 = C1_DEF;
		siopcb->tic = 0;
	}
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sfruart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb;
	const SIOPINIB	*siopinib;
	int i;

	siopcb = get_siopcb(siopid);
	siopinib = siopcb->siopinib;

	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UMR_OFFSET), siopinib->mr_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UC0_OFFSET), siopinib->c0_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UBRG_OFFSET), siopinib->brg_def);

	/*
	 *  VA݂̐ݒ
	 */
	set_ic_ilvl((VP)(siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
	set_ic_ilvl((VP)(siopinib->hint+TADR_SFR_S0RIC_OFFSET), RB_LEVEL);
	siopcb->cr1 = TBIT_UiC1_TE;
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);

	/*
	 * _~[f[^M
	 */
	sil_reb_mem((VP)(siopinib->cntrl+TADR_SFR_URB_OFFSET));
	sil_reb_mem((VP)(siopinib->cntrl+TADR_SFR_URB_OFFSET));

	for(i = 0 ; i < SFRUART_COUNT ; i++){	/* I[vMREADY܂ő҂ */
		if(sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)
			break;
	}

	siopcb->exinf = exinf;
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sfruart_cls_por(SIOPCB *siopcb)
{
	const SIOPINIB	*siopinib;

	siopinib = siopcb->siopinib;
	siopcb->tic = 0;
	set_ic_ilvl((VP)(siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
	sil_wrb_mem((VP)(siopinib->hint+TADR_SFR_S0RIC_OFFSET), 0);
	siopcb->cr1 = C1_DEF;
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
sfruart_snd_chr(SIOPCB *siopcb, char c)
{
	if(sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI){
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UTB_OFFSET), c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
sfruart_rcv_chr(SIOPCB *siopcb)
{
	if(sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_RI){
		return((INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_URB_OFFSET)));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sfruart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		siopcb->tic = TB_LEVEL;
		set_ic_ilvl((VP)(siopcb->siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
		break;
	case SIO_ERDY_RCV:
		siopcb->cr1 |= TBIT_UiC1_RE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);
		break;
	deafult:
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sfruart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		siopcb->tic = 0;
		set_ic_ilvl((VP)(siopcb->siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
		break;
	case SIO_ERDY_RCV:
		siopcb->cr1 &= ~TBIT_UiC1_RE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);
		break;
	deafult:
		break;
	}
}

/*
 *  uart0̎M
 */
void serial_in_handler1(void)
{
	SIOPCB *siopcb = &siopcb_table[0];
	if((siopcb->cr1 & TBIT_UiC1_RE) != 0) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sfruart_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  uart0̑M
 */
void serial_out_handler1(void)
{
	SIOPCB *siopcb = &siopcb_table[0];
	if(siopcb->tic > 0 && (sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)){
		/*
		 *  M\R[obN[`ĂяoD
		 */
		sfruart_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  uart1̎M
 */
void serial_in_handler2(void)
{
	SIOPCB *siopcb = &siopcb_table[1];
	if((siopcb->cr1 & TBIT_UiC1_RE) != 0){
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sfruart_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  uart1̑M
 */
void serial_out_handler2(void)
{
	SIOPCB *siopcb = &siopcb_table[1];
	if(siopcb->tic > 0 && (sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)){
		/*
		 *  M\R[obN[`ĂяoD
		 */
		sfruart_ierdy_snd(siopcb->exinf);
	}
}

