/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: oaks16.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

#ifndef _OAKS16_H_
#define	_OAKS16_H_

/*
 *  ݔԍ̒`
 */
#define	INT_BRK         0			/* BRK */
#define INT_INT3        4			/* INT3 */
#define INT_TB5	        5			/* ^C}B5 */
#define INT_TB4         6			/* ^C}B4 */
#define INT_TB3         7			/* ^C}B3 */
#define INT_SIO4INT5    8			/* SI/O4/INT5 */
#define INT_SIO3INT4    9			/* SI/O3/INT4 */
#define INT_BUS         10			/* oXՓˌo */
#define INT_DMA0        11			/* DMA0 */
#define INT_DMA1        12			/* DMA1 */
#define INT_KEY         13			/* L[͊荞 */
#define INT_AD          14			/* `-cϊ */
#define INT_S2TNACK     15			/* UART2M,NACK2 */
#define INT_S2RACK      16			/* UART2M,ACK2 */
#define INT_S0T         17			/* UART0M */
#define INT_S0R         18			/* UART0M */
#define INT_S1T         19			/* UART1M */
#define INT_S1R         20			/* UART1M */
#define INT_TA0         21			/* ^C}A0 */
#define INT_TA1         22			/* ^C}A1 */
#define INT_TA2         23			/* ^C}A2 */
#define INT_TA3         24			/* ^C}A3 */
#define INT_TA4         25			/* ^C}A4 */
#define INT_TB0         26			/* ^C}B0 */
#define INT_TB1         27			/* ^C}B1 */
#define INT_TB2         28			/* ^C}B2 */
#define INT_INT0        29			/* INT0 */
#define INT_INT1        30			/* INT1 */
#define INT_INT2        31			/* INT2 */

/*
 *  OAKS16 SFRAhX`
 *
 *  ݃WX^
 */
#define	TADR_SFR_INT_BASE       0x040			/* ݊֘Ãx[XAhX */
#define TADR_SFR_INT3IC_OFFSET  4				/* INT3 ݐ䃌WX^ */
#define TADR_SFR_TB5IC_OFFSET   5				/* timerB5 ݐ䃌WX^ */
#define TADR_SFR_TB4IC_OFFSET   6				/* timerB4 ݐ䃌WX^ */
#define TADR_SFR_TB3IC_OFFSET   7				/* timerB3 ݐ䃌WX^ */
#define TADR_SFR_SO4INT5_OFFSET 8				/* SI/O4/INT5 ݐ䃌WX^ */
#define TADR_SFR_SO3INT4_OFFSET 9				/* SI/O3/INT4 ݐ䃌WX^ */
#define TADR_SFR_BCNIC_OFFSET   10				/* oXՓˌoݐ䃌WX^ */
#define TADR_SFR_DMA0IC_OFFSET  11				/* DMA0ݐ䃌WX^ */
#define TADR_SFR_DMA1IC_OFFSET  12				/* DMA1ݐ䃌WX^ */
#define TADR_SFR_KUPIC_OFFSET   13				/* L[͊ݐ䃌WX^ */
#define TADR_SFR_ADIC_OFFSET    14				/* A-Dϊݐ䃌WX^ */
#define	TADR_SFR_S2TIC_OFFSET   15				/* uart2Mݐ䃌WX^ */
#define	TADR_SFR_S2RIC_OFFSET   16				/* uart2Mݐ䃌WX^ */
#define	TADR_SFR_S0TIC_OFFSET   17				/* uart0Mݐ䃌WX^ */
#define	TADR_SFR_S0RIC_OFFSET   18				/* uart0Mݐ䃌WX^ */
#define	TADR_SFR_S1TIC_OFFSET   19				/* uart1Mݐ䃌WX^ */
#define	TADR_SFR_S1RIC_OFFSET   20				/* uart1Mݐ䃌WX^ */
#define	TADR_SFR_TA0IC_OFFSET   21				/* timerA0 ݐ䃌WX^ */
#define TADR_SFR_TA1IC_OFFSET   22				/* timerA1 ݐ䃌WX^ */
#define TADR_SFR_TA2IC_OFFSET   23				/* timerA2 ݐ䃌WX^ */
#define TADR_SFR_TA3IC_OFFSET   24				/* timerA3 ݐ䃌WX^ */
#define TADR_SFR_TA4IC_OFFSET   25				/* timerA4 ݐ䃌WX^ */
#define TADR_SFR_TB0IC_OFFSET   26				/* timerB0 ݐ䃌WX^ */
#define TADR_SFR_TB1IC_OFFSET   27				/* timerB1 ݐ䃌WX^ */
#define TADR_SFR_TB2IC_OFFSET   28				/* timerB2 ݐ䃌WX^ */
#define TADR_SFR_INT0IC_OFFSET  29				/* INT0 ݐ䃌WX^ */
#define TADR_SFR_INT1IC_OFFSET  30				/* INT1 ݐ䃌WX^ */
#define TADR_SFR_INT12C_OFFSET  31				/* INT2 ݐ䃌WX^ */

/*
 *  DMAWX^
 */
#define TADR_SFR_SAR0           0x020			/* DMA0\[X|C^ */
#define TADR_SFR_DAR0           0x024			/* DMA0fXeBl[V|C^ */
#define TADR_SFR_TCR0			0x028			/* DMA0]JE^ */
#define TADR_SFR_DM0CON         0x02c			/* DMA0䃌WX^ */
#define TADR_SFR_SAR1           0x030			/* DMA1\[X|C^ */
#define TADR_SFR_DAR1           0x034			/* DMA1fXeBl[V|C^ */
#define TADR_SFR_TCR1			0x038			/* DMA1]JE^ */
#define TADR_SFR_DM1CON         0x03c			/* DMA1䃌WX^ */

/*
 *  ^C}[Ƃ̑̃foCXWX^
 */
#define TADR_SFR_TBSR           0x340			/* timerB3,4,5JEgJntO */
#define TADR_SFR_TA11           0x342			/* timerA1-1WX^ */
#define TADR_SFR_TA21           0x344			/* timerA2-1WX^ */
#define TADR_SFR_TA41           0x346			/* timerA4-1WX^ */
#define TADR_SFR_INVC0          0x348			/* OPWM䃌WX^O */
#define TADR_SFR_INVC1          0x349			/* OPWM䃌WX^P */
#define TADR_SFR_IDB0           0x34a			/* Oo̓obt@WX^O */
#define TADR_SFR_IDB1           0x34b			/* Oo̓obt@WX^P */
#define TADR_SFR_DTT            0x34c			/* Zh~^C} */
#define TADR_SFR_ICTB2          0x34d			/* timerB2ݔpxݒJE^ */
#define TADR_SFR_TB3            0x350			/* timerB3WX^ */
#define TADR_SFR_TB4            0x352			/* timerB4WX^ */
#define TADR_SFR_TB5            0x354			/* timerB5WX^ */
#define	TADR_SFR_TB3MR          0x35b			/* timerB3[hWX^ */
#define	TADR_SFR_TB4MR          0x35c			/* timerB4[hWX^ */
#define	TADR_SFR_TB5MR          0x35d			/* timerB5[hWX^ */
#define TADR_SFR_IFSR           0x35f			/* ݗvIWX^ */

#define TADR_SFR_S3TRR          0x360			/* SI/O3MWX^ */
#define TADR_SFR_S3C            0x362			/* SI/O3䃌WX^ */
#define TADR_SFR_S3BRG          0x363			/* SI/O3]xWX^ */
#define TADR_SFR_S4TRR          0x364			/* SI/O4MWX^ */
#define TADR_SFR_S4C            0x366			/* SI/O4䃌WX^ */
#define TADR_SFR_S4BRG          0x367			/* SI/O4]xWX^ */

#define	TADR_SFR_TABSR          0x380			/* JEgJntO */
#define TADR_SFR_CPSRF          0x381			/* Zbg vXP[ ZbgtO */
#define TADR_SFR_ONSF           0x382			/* Vg X^[gtO */
#define TADR_SFR_TRGSR          0x383			/* gK[ZNg WX^ */
#define	TADR_SFR_UDF            0x384			/* Abv_EtO */
#define	TADR_SFR_TA0            0x386			/* timerA0WX^ */
#define TADR_SFR_TA1            0x388			/* timerA1WX^ */
#define TADR_SFR_TA2            0x38a			/* timerA2WX^ */
#define TADR_SFR_TA3            0x38c			/* timerA3WX^ */
#define TADR_SFR_TA4            0x38e			/* timerA4WX^ */
#define TADR_SFR_TB0            0x390			/* timerB0WX^ */
#define TADR_SFR_TB1            0x392			/* timerB1WX^ */
#define TADR_SFR_TB2            0x394			/* timerB2WX^ */
#define	TADR_SFR_TA0MR          0x396			/* timerA0[hWX^ */
#define	TADR_SFR_TA1MR          0x397			/* timerA1[hWX^ */
#define	TADR_SFR_TA2MR          0x398			/* timerA2[hWX^ */
#define	TADR_SFR_TA3MR          0x399			/* timerA3[hWX^ */
#define	TADR_SFR_TA4MR          0x39a			/* timerA4[hWX^ */
#define	TADR_SFR_TB0MR          0x39b			/* timerB0[hWX^ */
#define	TADR_SFR_TB1MR			0x39c			/* timerB1[hWX^ */
#define	TADR_SFR_TB2MR          0x39d			/* timerB2[hWX^ */
#define	TADR_SFR_TB2SR          0x39e			/* timerB2XyV[hWX^ */

/*
 *  VAWX^
 */
#define	TADR_SFR_UART0_BASE     0x3a0			/* uart0WX^x[XAhX */
#define	TADR_SFR_UART1_BASE     0x3a8			/* uart1WX^x[XAhX */
#define	TADR_SFR_UART2_BASE     0x378			/* uart2WX^x[XAhX */
#define	TADR_SFR_U2SMR          0x377			/* uart2ꃂ[hWX^ */
#define	TADR_SFR_U2SMR2         0x376			/* uart2ꃂ[hWX^Q */
#define	TADR_SFR_U2SMR3         0x375			/* uart2ꃂ[hWX^R */

#define	TADR_SFR_UMR_OFFSET     0				/* uartM[hWX^ */
#define	TADR_SFR_UBRG_OFFSET    1				/* uart{[[gWFl[^ */
#define	TADR_SFR_UTB_OFFSET     2				/* uartMobt@WX^ */
#define	TADR_SFR_UC0_OFFSET     4				/* uartM䃌WX^#0 */
#define	TADR_SFR_UC1_OFFSET     5				/* uartM䃌WX^#1 */
#define	TADR_SFR_URB_OFFSET     6				/* uartMobt@WX^ */
#define	TADR_SFR_UC2_OFFSET     16				/* uartM䃌WX^#2 */

/*
 *  A-D/D-AWX^
 */
#define TADR_SFR_AD0            0x3c0			/* A-DWX^O */
#define TADR_SFR_AD1            0x3c2			/* A-DWX^P */
#define TADR_SFR_AD2            0x3c4			/* A-DWX^Q */
#define TADR_SFR_AD3            0x3c6			/* A-DWX^R */
#define TADR_SFR_AD4            0x3c8			/* A-DWX^S */
#define TADR_SFR_AD5            0x3ca			/* A-DWX^T */
#define TADR_SFR_AD6            0x3cc			/* A-DWX^U */
#define TADR_SFR_AD7            0x3ce			/* A-DWX^V */
#define TADR_SFR_ADCON2         0x3d4			/* A-D䃌WX^Q */
#define TADR_SFR_ADCON0         0x3d6			/* A-D䃌WX^O */
#define TADR_SFR_ADCON1         0x3d7			/* A-D䃌WX^P */
#define TADR_SFR_DA0            0x3d8			/* D-AWX^O */
#define TADR_SFR_DA1            0x3da			/* D-AWX^P */
#define TADR_SFR_DACON          0x3dc			/* D-A䃌WX^ */

/*
 *  ėp|[gWX^
 */
#define TADR_SFR_P0             0x3e0           /* |[gP0WX^ */
#define TADR_SFR_P1             0x3e1           /* |[gP1WX^ */
#define TADR_SFR_PD0            0x3e2			/* |[gP0WX^ */
#define TADR_SFR_PD1            0x3e3			/* |[gP1WX^ */
#define TADR_SFR_P2             0x3e4			/* |[gP2WX^ */
#define TADR_SFR_P3             0x3e5			/* |[gP3WX^ */
#define	TADR_SFR_PD2            0x3e6			/* |[gP2WX^ */
#define	TADR_SFR_PD3            0x3e7			/* |[gP3WX^ */
#define TADR_SFR_P4             0x3e8			/* |[gP4WX^ */
#define	TADR_SFR_P5             0x3e9			/* |[gP5WX^ */
#define	TADR_SFR_PD4            0x3ea			/* |[gP4WX^ */
#define	TADR_SFR_PD5            0x3eb			/* |[gP5WX^ */
#define TADR_SFR_P6             0x3ec			/* |[gP6WX^ */
#define	TADR_SFR_P7             0x3ed			/* |[gP7WX^ */
#define	TADR_SFR_PD6            0x3ee			/* |[gP6WX^ */
#define	TADR_SFR_PD7            0x3ef			/* |[gP7WX^ */
#define	TADR_SFR_P8             0x3f0			/* |[gP8WX^ */
#define TADR_SFR_P9             0x3f1			/* |[gP9WX^ */
#define	TADR_SFR_PD8            0x3f2			/* |[gP8WX^ */
#define TADR_SFR_PD9            0x3f3			/* |[gP9WX^ */
#define TADR_SFR_P10            0x3f4			/* |[gP10WX^ */
#define TADR_SFR_PD10           0x3f6			/* |[gP10WX^ */
#define	TADR_SFR_PUR0           0x3fc			/* vAbv䃌WX^O */
#define	TADR_SFR_PUR1           0x3fd			/* vAbv䃌WX^P */
#define	TADR_SFR_PUR2           0x3fe			/* vAbv䃌WX^Q */
#define	TADR_SFR_PCR            0x3ff			/* |[g䃌WX^ */

/*
 *  M䃌WX^1 (UART0,UART1)
 */
#define	TBIT_UiC1_RI	0x08	/* MtO */
#define	TBIT_UiC1_RE	0x04	/* Mrbg */
#define	TBIT_UiC1_TI	0x02	/* Mobt@tO */
#define	TBIT_UiC1_TE	0x01	/* Mrbg */

#define TBIT_UiC0_TXEPT	0x08	/* MWX^tO */

/*
 *  ݐ䃌WX^
 */
#define	TBIT_TAiIC_IR	0x08

/*
 *  JEgJntO (TABSR)
 */
#define TBIT_TABSR_TA0S	0x01

/*
 *  Abv_EtO(UDF)
 */
#define TBIT_UDF_TA0UD	0x01


/*
 *  |[gVݒ
 */
#define	P7_LED1					0x10			/* LED1rbg` */
#define	P7_LED2					0x20			/* LED2rbg` */

#ifndef _MACRO_ONLY

#include "cpu_defs.h"

/*
 *  ^[QbgVXe̕o
 */

Inline void
oaks16_putc(char c)
{
	volatile char * p = (volatile char *)TADR_SFR_UART1_BASE;

	while((p[TADR_SFR_UC1_OFFSET] & TBIT_UiC1_TI) == 0);
	p[TADR_SFR_UTB_OFFSET] = c;
}

#endif /* _MACRO_ONLY */
#endif /* _OAKS16_H_ */

