/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	vZbTˑW[iLinuxpj
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

#ifndef _MACRO_ONLY

/*
 *  LinuxpWCN[ht@C
 */

#include <signal.h>
#include <setjmp.h>

/*
 *  chg_ims/get_ims T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IMS

/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	jmp_buf env;		/* CPUReLXg */
} CTXB;

/*
 *   CPUOnh
 */

#define EXCHNO_ZDIV  SIGFPE

/*
 *  VXeԎQ
 */


Inline int
current_stack()
{
    struct sigaltstack      ss;

    sigaltstack(((void *)0), &ss);
    return(ss.ss_flags & SS_ONSTACK);
}


Inline BOOL
sense_context()
{
	return(current_stack());
}

Inline BOOL
sense_lock()
{
    sigset_t currentSet;
    
    sigprocmask(SIG_BLOCK, ((void *)0), &currentSet);

#if defined(linux) & (defined(i386) | defined(_i386_) | defined(__i386__))
    if(currentSet.__val[0] == ~(0 | (1<<(SIGKILL-1)) | (1<<(SIGSTOP-1)))
       &&  currentSet.__val[1] == ~0 )
        return(TRUE);
    else
        return(FALSE);
#else
    
#error not supported.
    
#endif /* linux */    
}


#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 */

#ifdef SUPPORT_CHG_IMS
extern IMS	task_sigmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IMS */

Inline void
t_lock_cpu()
{
    sigset_t  newmask;
    
    sigfillset(&newmask);
    sigprocmask(SIG_SETMASK,&newmask,0);
}

Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IMS
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽
	 *  ߁C̓r task_intmask 邱Ƃ͂ȂD
	 */
    sigprocmask(SIG_SETMASK,&task_sigmask,0);
#else /* SUPPORT_CHG_IMS */
    sigset_t  mask;
    
    sigemptyset(&mask);
    sigprocmask(SIG_SETMASK,&mask,0);
#endif /* SUPPORT_CHG_IMS */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern IMS	int_sigmask;	/* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu()
{
    sigset_t  mask;
    
    sigfillset(&mask);
    sigprocmask(SIG_SETMASK,&mask,&int_sigmask);
}

Inline void
i_unlock_cpu()
{
    sigprocmask(SIG_SETMASK,&int_sigmask,0);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch();


/*
 *  ݂̃ReLXĝĂăfBXpb`
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */

extern void    exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */


/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
    /*
     *  SIGUSR1ubNAX^bN؂ւLœo^B
     *  Dxtꍇ̓}XNrbgw肷
     *  Kv̂ł̕@͎gȂB
     */
    
    struct sigaction action;

    action.sa_handler = inthdr;
    sigemptyset(&action.sa_mask);
    sigaddset(&action.sa_mask,SIGUSR1);
    action.sa_flags = SA_ONSTACK;
    
    sigaction(inhno, &action, 0);    
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
    /*
     * ubN}XNAX^bN؂ւLœo^B
     */
    struct sigaction action;

    action.sa_handler = exchdr;
    sigemptyset(&action.sa_mask);
    sigaddset(&action.sa_mask,SIGUSR1);    
    action.sa_flags = SA_ONSTACK;    
    sigaction(excno, &action, 0);
}

/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̏o̐}N
 *
 *  VOisĂƃVOiX^bNɎIɐ؂ւB
 *  SĂ̊荞݃nh̓fBXpb`NSIGUSR1}XN
 *  삷B̂reqflg̃`FbNVOisċNꂽ
 *  nhŃfBXpb`vĂ
 */


#define	INTHDR_ENTRY(inthdr)      \
void inthdr##_entry(void){        \
     inthdr();                           /* 荞݃nhĂяo */ \
     if(_kernel_reqflg)                  /* regflg TRUEł      */ \
       raise(SIGUSR1);                   /* fBXpb`Ăяo   */ \
}                                      

#define INT_ENTRY(inthdr)   inthdr##_entry


/*
 *  CPUOnh̏o̐}N
 *
 *  VOisĂƃVOiX^bNɎIɐ؂ւB 
 *  SĂCPUOnh̓fBXpb`NSIGUSR1}XN
 *  삷B̂reqflg̃`FbNVOisċNꂽ
 *  nhŃfBXpb`vĂ 
 */
#define	EXCHDR_ENTRY(exchdr)	  \
void exchdr##_entry(VP sp){        \
     exchdr(sp);                         /* 荞݃nhĂяo */ \
     if(_kernel_reqflg)                  /* regflg TRUEł      */ \
       raise(SIGUSR1);                   /* fBXpb`Ăяo   */ \
}

#define EXC_ENTRY(exchdr) exchdr##_entry

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃fBXpb`
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x1000) == 0);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}


/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */







