/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#include <h8s_sci.h>

/*
 *  H8SSCIp ȈSIOhCo
 *  EĹAQ`lpɋLqĂBH8SV[Y̒ɂ́AQ`l
 *    ȏT|[gĂ`bv邪ÂƂ̑Ή͗eՂłB
 */

/* TNUM_SIOP : T|[gVA|[g̐ (ftHgl 2)
   TNUM_PORT : T|[gVAI/O|[g̐ (ftHgl 2)
   (sys_config.h ɋL) */

/* ȉŁAWX^̃AhXAUW ^փLXgĂB́Ax[X
   AhXɃItZbglāAŏIIȃWX^̃AhX߂Ă
   ߂łB擾ɁAŏII VP ^ɃLXgĂB(h8s_sci.h) */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	UW	reg_base;	/* WX^̃x[XAhX */
	UB	smr_def;	/* SMR ݒl b6-b3;
				   (MrbgAXgbvrbgCpeB) */
	UB	boud_brr_def;	/* BRR ݒli{[[g̐ݒlj */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT		exinf;		/* g */
	BOOL		openflag;	/* I[vς݃tO */
	BOOL		getready;	/* M */
	BOOL		putready;	/* 𑗐Mł */
};

/*
 *  VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (UW)	SCI0_BASE_ADDR,
	  (UB)	0,
	  (UB)	BRR_RATE		/* N l */
	},
#if TNUM_SIOP >= 2
	{ (UW)	SCI1_BASE_ADDR,
	  (UB)	0,
	  (UB)	BRR_RATE		/* N l */
	}
#endif /* TNUM_SIOP >= 2 */
};

/*
 *  VAI/O|[gubN̎o
 */
#define INDEX_SIOPINIB(siopid)	((UINT)((siopid) - 1))
#define get_siopinib(siopid)	(&(siopinib_table[INDEX_SIOPINIB(siopid)]))

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SCIpWX^֐
 */
Inline void
h8s_sci_or( const SIOPINIB *siopinib, UW reg, UB val )
{
	h8s_sci_wrb( siopinib->reg_base, reg, h8s_sci_reb( siopinib->reg_base, reg ) | val );
}

Inline void
h8s_sci_and( const SIOPINIB *siopinib, UW reg, UB val )
{
	h8s_sci_wrb( siopinib->reg_base, reg, h8s_sci_reb( siopinib->reg_base, reg ) & val );
}

/*
 *  Mł邩H
 */
Inline BOOL
h8s_sci_getready(SIOPCB *siopcb)
{
	siopcb->getready = FALSE;
	if( h8s_sci_reb( siopcb->siopinib->reg_base, (UW) SSR ) & RDRF )
		siopcb->getready = TRUE;

	return( siopcb->getready );
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
h8s_sci_putready(SIOPCB *siopcb)
{
	siopcb->putready = FALSE;
	if( h8s_sci_reb( siopcb->siopinib->reg_base, (UW) SSR ) & TDRE )
		siopcb->putready = TRUE;

	return( siopcb->putready );
}

/*
 *  M̎o
 */
Inline char
h8s_sci_getchar(SIOPCB *siopcb)
{
	/* RDRFNA */
	h8s_sci_and( siopcb->siopinib, (UW) SSR, (UB) ~RDRF );

	return( (char) h8s_sci_reb( siopcb->siopinib->reg_base, (UW) RDR ) );
}

/*
 *  M镶̏
 */
Inline void
h8s_sci_putchar(SIOPCB *siopcb, char c)
{
#ifndef GDB_STUB
	h8s_sci_wrb( siopcb->siopinib->reg_base, (UW) TDR, c );

	/* TDRENA */
	h8s_sci_and( siopcb->siopinib, (UW) SSR, (UB) ~TDRE );
#else
	stub_putc( c );
#endif
}

/*
 *  SIOhCȍ[`
 */
void
h8s_sci_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  SIOWX^[`
 */
void
h8s_sci_init_siopinib( const SIOPINIB  *siopinib )
{
	/*
	 * SCIWX^̏
	 */

	/* M~ */
	h8s_sci_and( siopinib, (UW) SCR, (UB) ~( TE | RE ) );

	/* rbgȂǐݒ */
	h8s_sci_wrb( siopinib->reg_base, (UW) SMR, siopinib->smr_def );

	/* {[[gݒ */
	h8s_sci_wrb( siopinib->reg_base, (UW) BRR, siopinib->boud_brr_def );

	/* ݋֎~ƃNbN\[XI */
	h8s_sci_and( siopinib, (UW) SCR, (UB) ~( TIE | RIE | MPIE | TEIE | CKE1 | CKE0 ) );

	/* {[[g̈艻(1bit̑҂) */
	sil_dly_nse( 1/BAUD_RATE );

	/* G[tONA */
	h8s_sci_and( siopinib, (UW) SSR, ~( ORER | FER | PER ) );

	/* MAM݋ */
	h8s_sci_or( siopinib, (UW) SCR, ( RIE | TE | RE ) );
}

/*
 *  J[lÑo[i[o͗p̏
 */
void
h8s_sci_init(void)
{
	h8s_sci_init_siopinib( get_siopinib(1) );
#if TNUM_SIOP >= 2
	h8s_sci_init_siopinib( get_siopinib(2) );
#endif /* TNUM_SIOP >= 2 */
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
h8s_sci_openflag(void)
{
#if TNUM_SIOP < 2
	return( siopcb_table[0].openflag );
#else /* TNUM_SIOP < 2 */
	return( siopcb_table[0].openflag || siopcb_table[1].openflag );
#endif /* TNUM_SIOP < 2 */
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
h8s_sci_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB 		*siopcb = get_siopcb(siopid);
	const SIOPINIB  *siopinib = siopcb->siopinib;

#ifndef GDB_STUB
	/* SCIWX^̏ */
	h8s_sci_init_siopinib( siopinib );
#endif	/* GDB_STUB */

	/* ݃xݒAݗvNÁAsio_opn_por ōsB */

	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
h8s_sci_cls_por(SIOPCB *siopcb)
{
	/* TEND  1 ɂȂ܂ő҂ */
	while ( !(h8s_sci_reb( siopcb->siopinib->reg_base, (UW) SSR ) & TEND ) );

	h8s_sci_and( siopcb->siopinib, (UW) SCR, ~( TE | RE ) );
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
h8s_sci_snd_chr(SIOPCB *siopcb, char c)
{
	if( h8s_sci_putready(siopcb) ) {
		h8s_sci_putchar(siopcb, c);
		siopcb->putready = FALSE;
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
h8s_sci_rcv_chr(SIOPCB *siopcb)
{
	if( h8s_sci_getready(siopcb) ) {
		siopcb->getready = FALSE;
		return( (INT)(UB) h8s_sci_getchar(siopcb) );
			/* UB ̃LXǵAgh~邽 */
	}

	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
h8s_sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		h8s_sci_or( siopcb->siopinib, (UW) SCR, TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_or( siopcb->siopinib, (UW) SCR, RIE );
		return;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
h8s_sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch( cbrtn ) {
	case SIO_ERDY_SND:
		h8s_sci_and( siopcb->siopinib, (UW) SCR, (UB) ~TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_and( siopcb->siopinib, (UW) SCR, (UB) ~RIE );
		return;
	}
}

/*
 *  SIO̊݃T[rX[` (SCI0p)
 */
void
h8s_sci0_isr_in()
{
	SIOPCB *siopcb = get_siopcb(1);

	/* MʒmR[obN[`̌Ăяo */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_rcv( siopcb->exinf );
	}
}

void
h8s_sci0_isr_out()
{
	SIOPCB *siopcb = get_siopcb(1);

	/* M\R[obN[`̌Ăяo */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_snd( siopcb->exinf );
	}
}

/*
 *  SIO̎MG[݃T[rX[` (SCI0p)
 *
 *  G[́ALG[tÕNÂ݁B
 *  EI[o[G[At[~OG[ApeBG[
 */
void
h8s_sci0_isr_error(void)
{
	SIOPCB *siopcb = get_siopcb(1);

	if( siopcb->openflag ) {
		/*  G[tONA  */
		h8s_sci_and( siopcb->siopinib, (UW) SSR, ~( RDRF | ORER | FER | PER ) );
	}
}

/*
 *  SIO̊݃T[rX[` (SCI1p)
 */
void
h8s_sci1_isr_in()
{
	SIOPCB *siopcb = get_siopcb(2);

	/* MʒmR[obN[`̌Ăяo */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_rcv( siopcb->exinf );
	}
}

void
h8s_sci1_isr_out()
{
	SIOPCB *siopcb = get_siopcb(2);

	/* M\R[obN[`̌Ăяo */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_snd( siopcb->exinf );
	}
}

/*
 *  SIO̎MG[݃T[rX[` (SCI1p)
 *
 *  G[́ALG[tÕNÂ݁B
 *  EI[o[G[At[~OG[ApeBG[
 */
void
h8s_sci1_isr_error(void)
{
	SIOPCB *siopcb = get_siopcb(2);

	if( siopcb->openflag ) {
		/*  G[tONA  */
		h8s_sci_and( siopcb->siopinib, (UW) SSR, ~( RDRF | ORER | FER | PER ) );
	}
}

/*
 *  H8S  SCI p|[Oo (LOGTASK_PORTIDpAsys_putcŗp)
 */
void
h8s_sci0_putchar_pol( char c )
{

	const SIOPINIB  *siopinib = get_siopinib( LOGTASK_PORTID );

	/* TDRE  1 ɂȂ܂ő҂ */
	while ( !(h8s_sci_reb( siopinib->reg_base, (UW) SSR ) & TDRE ) );

	h8s_sci_wrb( siopinib->reg_base, (UW) TDR, (UB) c );

	/* TDRENA */
	h8s_sci_and( siopinib, (UW) SSR, (UB) ~TDRE );

	/* TEND  1 ɂȂ܂ő҂ */
	while ( !(h8s_sci_reb( siopinib->reg_base, (UW) SSR ) & TEND ) );
}
