/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _H8S_SIL_H_
#define _H8S_SIL_H_

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

/*
 *  H8SWX^EANZXC^tF[X
 *@@x[XAhXH8S_BASE_ADDRh8s.hŒ`A
 *@@CPU샂[hɂAgB
 */

/*
 *  x[XAhX̉Z
 *@@UHŃLXgĂ̂́AQ̈ӖB
 *@@@E16rbgo
 *@@@EZ̍ۂ̕gh
 */
#define ADD_BASE_ADDR(addr)	(VP)(H8S_BASE_ADDR + (UW)(UH)(addr))

/*  WX^ւ̃ANZX  */
#define h8s_reb_reg(addr)	sil_reb_mem(ADD_BASE_ADDR(addr) )
#define h8s_wrb_reg(addr, val)	sil_wrb_mem(ADD_BASE_ADDR(addr), (VB)(val))

#define h8s_reh_reg(addr)	sil_reh_mem(ADD_BASE_ADDR(addr) )
#define h8s_wrh_reg(addr, val)	sil_wrh_mem(ADD_BASE_ADDR(addr), (VH)(val))

/*
 *  _Z
 */
#define h8s_orb_reg(addr, val)	h8s_wrb_reg(addr, h8s_reb_reg(addr) | (val))
#define h8s_andb_reg(addr, val) h8s_wrb_reg(addr, h8s_reb_reg(addr) & (val))

#define h8s_orh_reg(addr, val)	h8s_wrh_reg(addr, h8s_reh_reg(addr) | (val))
#define h8s_andh_reg(addr, val)	h8s_wrh_reg(addr, h8s_reh_reg(addr) & (val))

#endif /* _H8S_SIL_H_ */
