/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	vZbT̓ꖽ߂̃CC֐`iH8pj
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  䃌WX^̑֐
 */

/*
 *  RfVR[hWX^iCCRǰݒl̓Ǐo
 */
Inline UB
current_ccr(void)
{
    UB	ccr;
    Asm("stc.b ccr,%0l" : "=r"(ccr));
    return(ccr);
}

/*
 *  RfVR[hWX^iCCRǰݒl̕ύX
 */
Inline void
set_ccr(UB ccr)
{
	Asm("ldc.b %0l, ccr" : : "r"(ccr) );
}

/*
 *  NMIׂĂ݂̊֎~
 */
Inline void
disint(void)
{
    Asm("orc #"str_H8INT_DIS_ALL",ccr");
}

/*
 *  ׂĂ݂̊
 */
Inline void
enaint(void)
{
    Asm("andc #"str_H8INT_ENA_ALL",ccr");
}

/*
 * rbgNA
 */
Inline void
bitclr (UB *addr, UB bit)
{
    Asm("bclr %1l, @%0" : : "r"(addr), "r"(bit));
}

/*
 * rbgZbg
 */
Inline void
bitset (UB *addr, UB bit)
{
    Asm("bset %1l, @%0" : : "r"(addr), "r"(bit));
}

#endif /* _CPU_INSN_H_ */
