/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: user_config.h,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

#ifndef _USER_CONFIG_H_
#define _USER_CONFIG_H_

/*
 *  [U[ERtBM[V̒`
 */

/*
 *  chg_ipmT|[g邩ǂ̒`
 *@@AZupuser_config_asm.incɂl̒`KvȂ̂Œ
 */
#define SUPPORT_CHG_IPM

/*
 *  vxget_timT|[g邩ǂ̒`
 */
#define SUPPORT_VXGET_TIM

/*
 *  NbNg [Hz]
 *@@@user_config_asm.incɂl̒`KvȂ̂Œ
 */
#define CPU_CLOCK               24576000ul


/*
 *  VA|[g̐ݒ
 */

/*
 *  T|[gVAfoCX̐iő 2j
 *@@user_config_asm.incɂl̒`KvȂ̂Œ
 */
#define TNUM_PORT               1u

/*
 *  |[gԍ
 *
 *  @{hw_serial.hŒ`ׂATvvO
 *  @QƂ邽߁AŒ`B
 */
#define SCI_PORTID1				1		/*  ύX֎~  */
#define SCI_PORTID2				2		/*    */

/*
 *  |[gԍ̊蓖
 *
 *  @E10T-USBŃfobOsۂɂ́ASCI1L邽߁A
 *  @[U[vOSCI0݂̂gpB
 *
 *@@|[gP̂Ƃ
 *@@@@{[gP(SCI0)FVXe|[giŒj
 *@@|[gQ̂Ƃ
 *@@@@{[gP(SCI0)FVXe|[g^[U[|[gI\
 *@@@@{[gQ(SCI1)F
 */
#if TNUM_PORT == 1u

#define SYSTEM_PORTID           SCI_PORTID1		/*  Œ  */

#elif TNUM_PORT == 2u    /* of #if TNUM_PORT == 1u */

#define SYSTEM_PORTID           SCI_PORTID1		/*  \  */
#define USER_PORTID             SCI_PORTID2

#else   /* of #if TNUM_PORT == 1u || TNUM_PORT == 2u */

#error TNUM_PORT <= 2u

#endif  /* of #if TNUM_PORT == 1u */

/*
 *  ჌xo͂ɗpVA|[g̃|[gԍ
 */
#define SCI_LOW_PORTID			SYSTEM_PORTID

/*  {[[gƃvCIeBEx  */
#define SCI_PORT1_BAUD_RATE     38400ul		/* {[[g [bps]     */
#define SCI_PORT1_IPM           IPM_LEVEL0	/* vCIeBx  */

#if TNUM_PORT == 2u

#define SCI_PORT2_BAUD_RATE     38400ul		/* {[[g [bps]     */
#define SCI_PORT2_IPM           IPM_LEVEL0	/* vCIeBx  */

#endif  /* of #if TNUM_PORT == 2u */


/*
 * G[荞݂A͊荞݂ƕʂɑ삷ꍇ̓RgOB
 *@@user_config_asm.incɂl̒`KvȂ̂Œ
 */
#if 0
#define H8_CFG_SCI_ERR_HANDLER
#endif


/*
 *  ^C}̐ݒ
 */

/*
 *  ^CeBbN̒`
 */

#define TIC_NUME        1u               /* ^CeBbN̎̕q */
#define TIC_DENO        1u               /* ^CeBbN̎̕ */

/*  ^C}ɋNbNg [kHz]  */
#define TIMER_CLOCK     ((CPU_CLOCK)/8000ul)     /* 8 */

/*  vCIeBx  */
#define SYSTEM_TIMER_IPM                IPM_LEVEL1


#endif /* _USER_CONFIG_H_ */
