/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: sys_config.h,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

/*
 *@^[QbgVXeˑW[ikldq HSB8F3048BF25pj
 *@@@J[lŎgp`
 *@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */

#include <sys_rename.h>

/*
 *  [U[ERtBM[V̒`
 */
#include <user_config.h>


/*
 *  ^[QbgVXẽn[hEFA̒`
 */

#include <h8_3048f.h>

/*
 *  NbZ[W̃^[Qbg
 */

#define TARGET_NAME     "Hokuto Electronic H8/3048F-ONE STARTER KIT"


#ifndef _MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */

extern void     sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^ďoŎ邱Ƃz肵
 *  ĂD
 */

extern void     sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^ďoŎ邱
 *  Ƃz肵ĂD
 */
extern void     sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*
 *  SOFTWARE_TERM_HOOK}NFatexit̏
 *  @֐̊O`΁Å֐SOFTWARE_TERM_HOOK
 *@@}NƂĒ`B
 */
/*  ͒`Ȃ  */


/*
 *  (1) VA|[g̐ݒ
 *  (2) ^C}[̐ݒ
 *  (3) OAhXԐ
 */

/*
 *  SCI ʒ萔A}N
 */

        /* SCI N[YȎ҂Ԃ̌vZɎgpB*/
#define H8_MIN_BAUD_RATE        9600ul

/*
 *  SYSTEM p SCI ̐ݒl
 */
                                /* VXeOo͂VA|[gԍ     */
#define LOGTASK_PORTID          SYSTEM_PORTID   /*  user_config.h  */

/*  ݒ背WX^̃x[XAhX  */
#define SCI_PORT1_BASE          H8SCI0

/*  vCIeBxݒp̃f[^  */
#define SCI_PORT1_IPR          H8IPRB
#define SCI_PORT1_IPR_BIT      H8IPR_SCI0_BIT

#define SCI_PORT1_SMR          0u
                        /* MtH[}bg                   */
                        /*                            */
                        /* LN^OXF8rbg          */
                        /* peBȂ                         */
                        /* XgbvrbgOXF1            */
                        /* NbNZNgij:1         */

#define INHNO_SERIAL_IN         IRQ_RXI0
#define INHNO_SERIAL_OUT        IRQ_TXI0
#define INHNO_SERIAL_ERR        IRQ_ERI0


#if TNUM_PORT == 2

#define SCI_PORT2_BASE          H8SCI1

/*  vCIeBxݒp̃f[^  */
#define SCI_PORT2_IPR          H8IPRB
#define SCI_PORT2_IPR_BIT      H8IPR_SCI1_BIT

#define SCI_PORT2_SMR          0u
                        /* MtH[}bg                   */
                        /*                            */
                        /* LN^OXF8rbg          */
                        /* peBȂ                         */
                        /* XgbvrbgOXF1            */
                        /* NbNZNgij:1         */

#define INHNO_SERIAL2_IN        IRQ_RXI1
#define INHNO_SERIAL2_OUT       IRQ_TXI1
#define INHNO_SERIAL2_ERR       IRQ_ERI1

#endif  /* of #if TNUM_PORT == 2u */

/*
 *  ^C}̐ݒ
 */

#define SYSTEM_TIMER            H8ITU0

#define SYSTEM_TIMER_CNT        (SYSTEM_TIMER + H8TCNT)
#define SYSTEM_TIMER_TCR        (SYSTEM_TIMER + H8TCR)
#define SYSTEM_TIMER_TIOR       (SYSTEM_TIMER + H8TIOR)
#define SYSTEM_TIMER_IER        (SYSTEM_TIMER + H8TIER)
#define SYSTEM_TIMER_IFR        (SYSTEM_TIMER + H8TSR)
#define SYSTEM_TIMER_TSTR       H8ITU_TSTR
#define SYSTEM_TIMER_GR         (SYSTEM_TIMER + H8GRA)

#define SYSTEM_TIMER_STR        H8TSTR_STR0
#define SYSTEM_TIMER_STR_BIT    H8TSTR_STR0_BIT
#define SYSTEM_TIMER_IE         H8TIER_IMIEA            /* interrupt mask */
#define SYSTEM_TIMER_IE_BIT     H8TIER_IMIEA_BIT
#define SYSTEM_TIMER_IF         H8TSR_IMIFA             /* match flag */
#define SYSTEM_TIMER_IF_BIT     H8TSR_IMIFA_BIT

#define INHNO_TIMER             IRQ_IMIA0

#define SYSTEM_TIMER_TCR_BIT    (H8TCR_CCLR0 | H8TCR_TPSC1 | H8TCR_TPSC0)
#define SYSTEM_TIMER_TIOR_BIT   (0u)

/*  vCIeBxݒp̃f[^  */
#define SYSTEM_TIMER_IPR                H8IPRA
#define SYSTEM_TIMER_IP_BIT             H8IPR_ITU0_BIT

/*
 *  I/O|[g DDȐl
 *      h8_sil.cDDRANZX[`ŎgpB
 *      |[gV͓͐p̂߁AȗĂB
 */
#define H8P1DDR0        0xffu	/*  AhXEoX  */
#define H8P2DDR0        0xffu	/*  AhXEoX  */
#define H8P3DDR0        0u	    /*  f[^EoX@  */
#define H8P4DDR0        0u      /*  f[^EoX@  */
#define H8P5DDR0        0x0fu	/*  AhXEoX  */
#define H8P6DDR0        0u
#define H8P8DDR0        H8P8DDR_CS1     /*  P83CS1ɐݒ  */
#define H8P9DDR0        0u
#define H8PADDR0        0u
#define H8PBDDR0        0u

/*
 *  SYSCȐl
 *      $SYSfBNgSYSCR_SYSƂĒ`e
 *      @rbg6-4 STSFX^oCE^C}EZNg
 *      @rbg2 NMIEGFNMIGbW
 */
#define SYSCR_SYS	0u


#endif /* _SYS_CONFIG_H_ */
