/*
 *  @(#) $Id: cq_starm.ld,v 1.8 2008/07/10 12:30:46 suikan Exp $
 */

PROVIDE (__stack = 0) ;
PROVIDE (hardware_init_hook = 0) ;
PROVIDE (software_init_hook = 0) ;
PROVIDE (software_term_hook = 0) ;
PROVIDE (default_nmi_handler = 0) ;
PROVIDE (default_hard_fault_handler = 0) ;

/*
* CQ-STARM(STM32F103VB)́A128kB̃tbVƁA20KBSRAMĂB
* ȉł͂ꂼ̃ZOg̐錾sB
*/
MEMORY{
    flash(arx)  : org = 0x08003000, len = 116K /* DFU12KB Ă */
    ram(w)      : org = 0x20000000, len = 16K
}


SECTIONS
{
	
	.reset_vector :	/* ZbgɎQƂOxNgB4Gĝ݁BFLASḦ̐擪ɂ */
	{
		KEEP (start.o(.rodata))
	} > flash 
	
    
    .text :
    {
        __text = . ;
        *(.text .stub .text.* .gnu.linkonce.t.*)

    } > flash
    
    .fini :
    {
        KEEP (*(.fini))
    } > flash
    
    _etext = . ;
    PROVIDE (etext = .) ;
    .rodata :
    {
        *(.rodata .rodata.* .gnu.linkonce.r.*)
    } > flash
    
    /*
    * ȉ̃ZNVŁA "AT(FOO)"́AAhXFOOɃIuWFNgzu邱ƂӖB
    * __idata_start́AO.ɏĂA.͌݃Jf[^zuĂ
    * ʒu\BÕZNV̗ꂩA݃Jf[^zuĂ̂flashłB
    * ܂A.dataflashɔzuBA"}>ram"́Asɂramɔzu
    * ƂӖB
    *
    * ȏ̂ƂA.dataflashɊi[Ă邪AvOsOramɃRs[
    * Ȃ΂ȂȂƂ킩BsĂ̂A$(CPU)/start.S łB
    */
    . = ALIGN(4) ;
    __idata_start = . ;
    .data : AT(__idata_start) 
    {
        __data_start = . ;
        *(.data)
    } > ram
    
    .eh_frame : AT(.){ KEEP (*(.eh_frame)) } > ram
 
    .gcc_except_table : AT(.){ *(.gcc_except_table) } > ram
 
    .ctors : AT(.)
    {
        KEEP (*crtbegin.o(.ctors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .ctors))
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
    } > ram
    
    .dtors : AT(.)
    {
        KEEP (*crtbegin.o(.dtors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .dtors))
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
    } > ram
  
    __idata_end = __idata_start + SIZEOF(.data) ;
    
    
    _edata  = . ;
    PROVIDE (edata = .) ;
    . = ALIGN(4) ;
    __bss_start = . ;
    .bss :
    {
        *(.bss)
        *(COMMON)
    } > ram
    _end = . ;
    __bss_end = . ;
    
    
	.master_stack ALIGN(4): 
	{
		KEEP (*(.master_stack))
	} > ram
    __master_stack = . -4;

    
	/* OxNgTCY傫2̙pɐ񂷂[BYTE]. ̐́ACORTEX-M3̃A[LeN`ɂvł  */
    
    .exc_vector ALIGN(256):	/*  OxNgB */
	{
		KEEP (*(.vector))
	} > ram
    
    
    
    
    PROVIDE (end = .) ;
    
    .comment        0 : { *(.comment) }
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }
}
