/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2008 by TOPPERS/JSP for CORTEX-M3 project
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.17 2008/08/02 07:52:58 suikan Exp $
 */

/*
 *	vZbTˑW[ AZuꕔiCORTEX-M3pj
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ^XNfBXpb`
 *
 *  dispatch ́CXbh[hE݋֎~ԂŌĂяoȂ΂Ȃ
 *  D
 *  runtsk, schedtsk jsp/kernel/task.hŎ̂悤ɐ錾Ă
 *
 *  extern TCB * runtsk;
 *  extern TCB * schedtsk;
 */
 	.syntax unified
	.text
	.globl dispatch
	.globl exit_and_dispatch
dispatch:
	push.w {r4 - r11, lr}	/* WX^ۑ */
	ldr r0, =runtsk			/* r0  &runtsk  */
	ldr r1, [r0]			/* r1  runtsk  */
	str sp, [r1, #TCB_sp]	/* runtsk->spɃ^XNX^bNۑ */
	ldr r2, =dispatch_r+1	/*@sĊJԒn擾 */
	str r2, [r1, #TCB_pc]	/* runtsk->pcɎsĊJԒnۑ */

exit_and_dispatch:
dispatcher:
	/*
	 *  ł̓Xbh[hE݋֎~ԂłȂ΂ȂȂD
	 */
	ldr r0, =runtsk			/* r0  &runtsk  */
	ldr r2, =schedtsk
	ldr r1,[r2]				/* schedtsk o */
	str r1,[r0]				/* *runtsk = *schedtsk */
	tst r1,r1				
	beq dispatcher_1		/* runtsk 邩H */
	ldr	sp,[r0,#TCB_sp]		/* runtsk->sp^XNX^bN𕜋A */
	ldr pc,[r0,#TCB_pc]		/* runtsk->sĊJԒn𕜋A */
	
dispatcher_1:
				/* X^bN MSP ɐ؂ւ */
	mrs		r3,control
	bic		r3,#02			/* CONTROL[1]Thread ModeMSPg悤ɂB */
	msr		control,r3
	isb						/* control̏ݏI҂@*/
	
	wfi						/* 荞ݑ҂ */
	/*
	 *  MSPɐ؂芷̂́CŔ銄ݏ
	 *  ɂǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *  vZbT҂[hɈڍs鏈ƁC݋Ƃ́C
	 *  sɍsȂKviCORTEX-M3 ł WFI߂
	 *  荞݋֎~ł荞ݓ͂SLEEP甲ô
	 *  ̂ŖȂjDsɍsȂȂꍇC݂
	 *  Ɋ݂C̒Ń^XNs\ԂɂȂ
	 *  ƁCsׂ^XNɂ炸vZbT҂[
	 *  hɂȂĂ܂D
	 *
	 *  ݂҂Ԃ́Cruntsk  NULLi=0jɐݒ肵Ȃ΂Ȃ
	 *  ȂD̂悤ɐݒ肵ȂƁC݃nh iget_tid 
	 *  Ăяoۂ̓삪dlɍvȂȂD
	 */
	 			/* WFI 𒆒f荞݂̎󂯕t */
	cpsie i				/* 荞݋ */
	nop					/*@Ŋ荞݂ */
	cpsid i				/* 荞݋֎~ */
	 
	orr r3,#02				/* CONTROL[1]Thread ModePSPg悤ɂB */
	msr	control,r3
	isb						/* control̏ݏI҂@*/
	 
	ldr r1, =reqflg
	ldr r2, [r1]			/* reqflg [h@*/
	tst r2,r2				/* 0? */
	beq dispatcher_1		/* NGXgȂȂ犄荞݂҂ */
	mov r2,#0
	str r2, [r1]			/* reqflg  FALSE  */
	b dispatcher
	
dispatch_r:
			/* r0 ɂ &runtskĂ */
			/* r1 ɂ runtskĂ */
	pop.w {r4 - r11}				/* WX^𕜋A. lr͍ŌɕA */
	ldrb r2, [r1,#TCB_enatex]		/* runtsk->enatex ^XNOԂ擾 */
	tst	r2, #(1<<TCB_enatex_bit)	/* enatex̓ZbgĂ邩 */
	beq dispatch_r_1				/* enatex  FALSE Ȃ烊^[ */
	ldr r2, [r1,#TCB_texptn]		/* runtsk->texptn */
	tst r2,r2						/* texptn  0   */
	beq dispatch_r_1				/* texptn  0 Ȃ烊^[ */
	ldr r1, =call_texrtn +1
	blx r1							/*   ^XNO[`̌ďo */
dispatch_r_1:
	pop {pc }						/* lr𕜋AāA̔ԒnidispatchĂяoԒnjɖ߂ */


	
	
/*
 *  ^XNN
 */
	.text
	.globl activate_r
activate_r:
	/*
	 *  ^XNN̓^XNO֎~Ă邽߁CŃ^
	 *  XNO[`Ăяo͐藧ȂD
	 *
	 *  ̃R[h́A^XNX^bNKvȏoBX^bN
	 *  𖄂ߍނ̂́Acpu_context.h activate_context()łB
	 */
	 pop {r0,lr}				/* extinfƖ߂Ԓn ( ext_tsk )ݒ */ 
	 cpsie i					/* ^XN͋NCPUAbNԂɂȂ */
	 pop {pc}					/* ^XN̊Jn */

/*
 *  ݃nh^CPUOnho
 *
 *  ret_int ւ́Anh[hAMSPA荞݋ԂœĂB̂Ƃ́AX^bN̗lq
 *  ȉ̂Ƃ
 *  [] <- MSP (R13)
 *  
 *  [xPSR]    +28
 *  [ PC ]    +24
 *  [ LR ]    +20
 *  [ R12]    +16
 *  [ R3 ]    +12
 *  [ R2 ]    + 8
 *  [ R1 ]    + 4
 *  [ R0 ] <- PSP
 */
	.text
 	.syntax unified
	.globl ret_int
ret_int:
	cpsid i					/* CPUbN (荞݋֎~) */
	mrs r12,psp				/* PSP̒l擾 */
	ldr r3,[R12,#28]		/* xPSR̒l擾 */
	ldr r2,=ret_int_0+1		/* ^XN[hɑJڂ邽߂̍ē˓_ݒ */
	stmdb r12!,{r0-r3}		/* U R12,LR,PC,xPSRۑBPCxPSRȊO͂ł߂ł */
	stmdb r12!,{r0-r3}		/* U r0,1,2,3,ۑBSł߂ł */
	msr psp,r12				/* PSPɐVlݒ */

/*
@* ł̃X^bN\͈ȉ̂Ƃ
@*
 *  [] <- PSP (R13)
 *  
 *  [xPSR]    +60
 *  [ PC ]    +56
 *  [ LR ]    +52
 *  [ R12]    +48
 *  [ R3 ]    +44
 *  [ R2 ]    +40
 *  [ R1 ]    +36
 *  [ R0 ] <- ÂPSP
 *  [xPSR]    +28
 *  [ PC ]    +24 : ret_int_0
 *  [ LR ]    +20
 *  [ R12]    +16
 *  [ R3 ]    +12
 *  [ R2 ]    + 8
 *  [ R1 ]    + 4
 *  [ R0 ] <- VPSP
 *  
 * ÂPSP艺̗̈́A^XN[hɑJڂ邽߂̋Uf[^łB
 */
	bx lr					/* 荞݂̕AB͎̔Ԓnɐiނ*/
ret_int_0:					/* Thread mode 荞݋֎~B PSP */
/*
@* ł̃X^bN\͈ȉ̂Ƃ
@*
 *  [xPSR]    +28
 *  [ PC ]    +24
 *  [ LR ]    +20
 *  [ R12]    +16
 *  [ R3 ]    +12
 *  [ R2 ]    +8
 *  [ R1 ]    +4
 *  [ R0 ] <- PSP(R13)
 */
	ldr r0,=reqflg			/* &reqflg */
	ldr r1,[r0]				/* reqflg擾 */
	tst r1,r1				/* reqflg == FLASE? */
	beq ret_int_2			/* FALSE->荞݂A */
	mov r1,#0				/* TRUE */
	str r1,[r0]				/* reqflg = FLALSE */
	ldr r0,=runtsk			/* &runtsk */
	ldr r1,[r0]				/* r0 <- runtsk */
	ldr r2,=enadsp
	ldr r3,[r2]				/* enadsp擾 */
	tst r3,r3				/* enadsp@== FALSE? */
	beq	ret_int_1			/*     then ret_int_1 */
	ldr r2,=schedtsk
	ldr r3,[r2]				/* schedtsk */
	cmp r1,r3				/* runtsk == schedtsk ? */
	beq	ret_int_1			/*     then ret_int_1 */
							/* enadspTRUEŁAruntsk != schedtsk  */
	ldr r0,=dispatch+1
	blx r0					/* dispatch() */
    b ret_int_2				/* 荞݂߂ */
ret_int_1:					/* tex̏ */
	ldr r0,=runtsk					/* &runtsk */
	ldr r1,[r0]						/* runtsk */
	ldrb r2, [r1,#TCB_enatex]		/* runtsk->enatex ^XNOԂ擾 */
	tst	r2, #(1<<TCB_enatex_bit)	/* enatex̓ZbgĂ邩 */
	beq ret_int_2					/* enatex  FALSE Ȃ烊^[ */
	ldr r2, [r1,#TCB_texptn]		/* runtsk->texptn */
	tst r2,r2						/* texptn  0   */
	beq ret_int_2					/* texptn  0 Ȃ烊^[ */
	ldr r1, =call_texrtn +1
	blx r1							/* call_texrtn() */

ret_int_2:					/* 荞݂߂BAThread ModeȂ̂ŁAEXC_RETRUN͎gȂ */
	ldr r1,[sp,#28]			/* xPSR */
	ldr r2,[sp,#24]			/* PC */
	ldr r3,[sp,#20]			/* LR */
	
	str r2,[sp,#28]         /* PC */
	str r3,[sp,#24]			/* LR */
	str r1,[sp,#20]			/* xPSR */
/*
@* ł̃X^bN\͈ȉ̂Ƃ
@*
 *  [ PC ]    +28
 *  [ LR ]    +24
 *  [xPSR]    +20
 *  [ R12]    +16
 *  [ R3 ]    +12
 *  [ R2 ]    +8
 *  [ R1 ]    +4
 *  [ R0 ] <- PSP (R13)
 */
	
	pop.w {r0-r3,r12,lr}	/* LRɂ͋xPSR */
	msr xpsr,lr				/* xPSR𕜋A */
	pop {lr}				/* LR𕜋A */
	cpsie	i				/* CPUAbN (荞݋) */
	pop {pc}				/* ߂Ԓnɔ */

/*
 *  ԑ҂
 */
	.globl _sil_dly_nse
_sil_dly_nse:
	subs r0, #SIL_DLY_TIM1	/* D0  SIL_DLY_TIM1  */
	bgt _sil_dly_nse_1		/* ʂ 0 ȉȂ烊^[ */
	bx lr
_sil_dly_nse_1:
	subs r0, #SIL_DLY_TIM2	/* D0  SIL_DLY_TIM2  */
	bgt _sil_dly_nse_1		/* ʂ 0 傫΃[v */
	bx lr
