/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *	vZbTˑW[iARM4vTpj
 */

#include "jsp_kernel.h"
#include "check.h"
#include <armv4.h>
#include "task.h"

/*
 * OxN^ɏ܂ꂽWv߂QƂAhX
 * 
 */
UW *arm_vector_add[8];


/*
 * Oɉnh̋NԒn
 */
UW arm_handler_add[8];


/*
 * 荞݂̃lXg񐔂̃JEg
 */
UW interrupt_count;


/*
 * CPU/݃nh̏oňꎞIɎgpX^bN
 */
UW int_stack[INT_STACK_SIZE];


/*
 *  CPUOnh̐ݒ
 */
void
define_exc(EXCNO excno, FP exchdr)
{
    arm_install_handler(excno,exchdr);
}


/*
 *  `̗Oꍇ̏
 */
void
undef_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. UNDEF");
    while(1);
}

void
swi_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. SWI");
  while(1);
}

void
prefetch_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. PREFETCH");
  while(1);
}

void
data_abort_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. DATA ABORT");
  while(1);
}


void
irq_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. IRQ");
  while(1);
}

void
fiq_exception(){
  syslog(LOG_EMERG, "Unregistered Exception occurs. FIQ");
  while(1);
}



/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{

    UW i,vector_value;

	interrupt_count = 1;
	
    /*
     * OxN^ɓo^Ă閽߂QƂAhXƁC
     *̃AhX̓e(nh̎s)ۑD
     */
    for(i = 0; i <=7; i++){
        vector_value = *(volatile UW *)(i*4);
        vector_value &= 0x00000fff;
        arm_vector_add[i] =  (UW *)(vector_value + 8) + i;
        arm_handler_add[i] = *(arm_vector_add[i]);
    }
}


/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{
    UW i;
    /*  xN^e[uɖ߂D*/
    for(i = 0; i <=7; i++)
        *arm_vector_add[i] = arm_handler_add[i];
}
