/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ns9360.ld,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */
/*
 * OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm","elf32-littlearm") 
*/
OUTPUT_FORMAT("elf32-bigarm")
OUTPUT_ARCH(arm)
	
PROVIDE(hardware_init_hook = 1);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);

SECTIONS
{
    . = 0x00 ;    
    .vector :
    {
    *(.vector)
    }
    
    .text :	
    {
        __text = . ; 	
        *(.text)
    }
    _etext = .	;
    PROVIDE (etext = .)	;
    .rodata : { *(.rodata) }
    . = ALIGN(4);
    .ctors :
    {
        PROVIDE(__CTOR_BEGIN__ = .);
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
        PROVIDE(__CTOR_END__ = .);
    }
    . = ALIGN(4);
    .dtors :
    {
        PROVIDE(__DTOR_BEGIN__ = .);
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
        PROVIDE(__DTOR_END__ = .);
       _endtext = .;
    }
    __idata_start = . ;
  .data :AT (_endtext)
  {
    _etext = _endtext;
    __data_start = .;
    PROVIDE (data_start = .);
    *(.data)
    *(.gnu.linkonce.d*)
    SORT(CONSTRUCTORS)
    *(.data1)
        *(.eh_frame)
        *(.jcr)
        *(.gcc_except_table)
    . = ALIGN(0x10);
  }
    __idata_end = __idata_start + SIZEOF(.data);

    .bss  : AT (_endtext  + SIZEOF(.data))
    {
      __bss_start = . ;
      *(.bss)
      *(COMMON)
      *(.stack)
      . += 12K;
      _stack_end = . ;
      PROVIDE (stack_end  = .)	;
    }

    _end = .		;
    __bss_end = .;
    PROVIDE (end = .)	;
 
   .ttb    : AT (__idata_end + SIZEOF(.bss))
  {
   . = ALIGN(0x4000);
   ttb_start = . ;
   *(.ttb)
   . += 32K;
   ttb_end = . ;
  }

    .comment 0 : { *(.comment) }	
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }	
  .debug_info 0 : { *(.debug_info) }
  .debug_abbrev 0 : { *(.debug_abbrev) }
  .debug_line 0 : { *(.debug_line) }
  .debug_frame 0 : { *(.debug_frame) }
  .debug_str 0 : { *(.debug_str) }
  .debug_loc 0 : { *(.debug_loc) }
  .debug_macinfo 0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames 0 : { *(.debug_varnames) }
  /* These must appear regardless of  .  */
}	

	
		
	