/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ns9360.c,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *    @\phCo
 */
#include <s_services.h>
#include <ns9360.h>

/*
 * UARTp ȈSIOhCo
 */

/*
 * VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{
		/* UART Channel A */
		 (VP)SC1SRA_REG , (VP)SC1FIFO_REG , (VP)SC1CRA_REG , (VP)SC1CRB_REG
		,(VP)SC1RCT_REG , (VP)SC1RBT_REG , (VP)SC1BRG_REG
		,(SCCRA_CE | SCCRA_WLS | SCCRA_DTR | SCCRA_RTS)
		,0x08000000
		,0x80000008
		,0x80000008
		,(0xC0140000 | 7)			/* 29.4912MHz /2/8 = 115200*16 */
		,BBBI_S1TX , BBBI_S1RX
	 }
#if TNUM_SIOP >= 2
    ,
    {
		/* UART Channel C */
		 (VP)SC3SRA_REG , (VP)SC3FIFO_REG , (VP)SC3CRA_REG , (VP)SC3CRB_REG
		,(VP)SC3RCT_REG ,(VP)SC3RBT_REG ,  (VP)SC3BRG_REG
		,(SCCRA_CE | SCCRA_WLS | SCCRA_DTR | SCCRA_RTS)
		,0x08000000
		,0x80000008
		,0x80000008
		,(0xC0140000 | 7)			/* 29.4912MHz /2/8 = 115200*16 */
		,BBBI_S3TX , BBBI_S3RX
	}
#endif
 };

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB  siopcb_table[TNUM_SIOP];

/*
 * VXeo͗pVA|[g
 */
SIOPCB      *sys_siopcb;


/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))


/*
 * M?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
	VW	dt;
	
	if(0 != siopcb->rxfdb)
		return TRUE;
	
	dt = sil_rew_mem((VP)siopcb->siopinib->pSraReg);
	return(dt &(SCSRA_RFS | SCSRA_RRDY));
}

/*
 * 𑗐Mł邩?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
	return(sil_rew_mem((VP)siopcb->siopinib->pSraReg)&(SCSRA_TRDY | SCSRA_THALF | SCSRA_TEMPTY));
}

/*
 *  M̎o
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
	UW	dt;
	
	if(0 == siopcb->rxfdb)
	{
		siopcb->rxfdb = (sil_rew_mem((VP)siopcb->siopinib->pSraReg) >> 20) & 0x03;
		if(0 == siopcb->rxfdb)
			siopcb->rxfdb = 4;
		
		siopcb->rxbuf = sil_rew_mem((VP)siopcb->siopinib->pFifoReg);
	}
	--(siopcb->rxfdb);
	dt = (siopcb->rxbuf >> 24) & 0xff;
	siopcb->rxbuf <<= 8;
	
	return (UB)dt;

}

/*
 *  M镶̏
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
    sil_wrb_mem((VP)siopcb->siopinib->pFifoReg, (VB)c);
}

/*
 *  M݋
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
		sil_wrw_mem((VP)BBBIE_REG,sil_rew_mem((VP)BBBIE_REG) | siopcb->siopinib->BbbiTx);
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
	sil_wrw_mem((VP)BBBIE_REG,sil_rew_mem((VP)BBBIE_REG) & ~siopcb->siopinib->BbbiTx);
}

/*
 *  M݋
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
	sil_wrw_mem((VP)BBBIE_REG,sil_rew_mem((VP)BBBIE_REG) | siopcb->siopinib->BbbiRx);
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
	sil_wrw_mem((VP)BBBIE_REG,sil_rew_mem((VP)BBBIE_REG) & ~siopcb->siopinib->BbbiRx);
}



/*
 * J[lÑOo͗p̏
 */
void
uart_init(ID siopid){
    SIOPCB      *siopcb;

	uart_initialize();

    siopcb = get_siopcb(siopid);

	sys_siopcb = siopcb;

    /* UART Initialize */
    sil_wrw_mem((VP)siopcb->siopinib->pCraReg,(VW)siopcb->siopinib->CraData);
	sil_wrw_mem((VP)siopcb->siopinib->pCrbReg,(VW)siopcb->siopinib->CrbData);
	sil_wrw_mem((VP)siopcb->siopinib->pRctReg,(VW)0);
	
    /* Set bound rate */
	sil_wrw_mem((VP)siopcb->siopinib->pBrgReg,siopcb->siopinib->BrgData);
}


/*
 *  I`bvUART̃|[Oo
 */
void
uart_putc(char c)
{
    UW buf_level;
    
    do{
        buf_level = sil_rew_mem((VP)sys_siopcb->siopinib->pSraReg) & SCSRA_TRDY;
    }while(buf_level == 0);
    
    sil_wrb_mem((VP)sys_siopcb->siopinib->pFifoReg,(VW)c);
}

/*
 *  SIOhCȍ[`
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  VAI/O|[gǗubN̏
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
        siopcb->rxfdb = 0;
        siopcb->rxbuf = 0;
        siopcb->siopid = i;
    }
}

/*
 * I[vĂ|[g邩
 */
BOOL
uart_openflag(ID siopid)
{
    return(siopcb_table[siopid].openflag);
}


/*
 * VAI/O|[g̃I[v
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;
	UW		n;
	
    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    /* UART Initialize */
    sil_wrw_mem((VP)siopinib->pCraReg,(VW)siopinib->CraData);
	sil_wrw_mem((VP)siopinib->pCrbReg,(VW)siopinib->CrbData);
	sil_wrw_mem((VP)siopinib->pRctReg,(VW)siopinib->RctData);
	sil_wrw_mem((VP)siopinib->pRbtReg,(VW)siopinib->RbtData);
	
    /* Set bound rate */
	sil_wrw_mem((VP)siopinib->pBrgReg,siopinib->BrgData);

    /* MRcvRdy,FIFO=HalfAMTxEmpty,FIFO-Half݋ */
	n = sil_rew_mem((VP)siopinib->pCraReg);
	n &=  (~(SCCRA_RIE | SCCRA_TIC));
	n |= (0xe00 | 0x0c);
    sil_wrw_mem((VP)siopinib->pCraReg,(VW)n);
	
    /* BBUS݋ */
	sil_wrw_mem((VP)BBBIE_REG,sil_rew_mem((VP)BBBIE_REG) | siopinib->BbbiRx);
	sil_wrw_mem((VP)INT_CFG8_11_REG,sil_rew_mem((VP)INT_CFG8_11_REG)|0x80000000);
	
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;
    siopcb->rxfdb = 0;
    siopcb->rxbuf = 0;

    return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
uart_cls_por(SIOPCB *siopcb)
{
    siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}


/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}


/*
 *  VAI/O|[gɑ΂鑗Mݏ
 */
static void
uart_Txisr_siop(SIOPCB *siopcb)
{
    /*
     *  M\R[obN[`ĂяoD
     */
    uart_ierdy_snd(siopcb->exinf);
}

/*
 *  VAI/O|[gɑ΂Mݏ
 */
static void
uart_Rxisr_siop(SIOPCB *siopcb)
{
    /*
     *  MʒmR[obN[`ĂяoD
     *  ő4(32bit)MĂ̂łőSM
     */
    while(1)
    {
        uart_ierdy_rcv(siopcb->exinf);
        if(0 == siopcb->rxfdb)
            break;                           /* Mς݃LN^Ȃ */
	}
}


/*
 *  SIOTx݃T[rX[`
 */
void
uart_Tx_isr()
{
	uart_Txisr_siop(&(siopcb_table[0]));
}

/*
 *  SIORx݃T[rX[`
 */
void
uart_Rx_isr()
{
	uart_Rxisr_siop(&(siopcb_table[0]));
	sil_wrw_mem((VP)siopcb_table[0].siopinib->pSraReg , 
					sil_rew_mem((VP)siopcb_table[0].siopinib->pSraReg) );
}

/*
 *  SIO2Tx݃T[rX[`
 */
void
uart2_Tx_isr()
{
	uart_Txisr_siop(&(siopcb_table[1]));
}

/*
 *  SIO2Rx݃T[rX[`
 */
void
uart2_Rx_isr()
{
	uart_Rxisr_siop(&(siopcb_table[1]));
	sil_wrw_mem((VP)siopcb_table[1].siopinib->pSraReg , 
					sil_rew_mem((VP)siopcb_table[1].siopinib->pSraReg) );
}


/*
 *  SIO̊݋[`
 */
void
uart_TxRx_Enable(ID siopid)
{
	sil_wrw_mem((VP)BBBIE_REG,
				sil_rew_mem((VP)BBBIE_REG) | siopcb_table[siopid].siopinib->BbbiTx 
		                                   | siopcb_table[siopid].siopinib->BbbiRx);
}

/*
 *  SIO̊݋֎~[`
 */
void
uart_TxRx_Disable(ID siopid)
{
		sil_wrw_mem((VP)BBBIE_REG,
				sil_rew_mem((VP)BBBIE_REG) & ~(siopcb_table[siopid].siopinib->BbbiTx
												 | siopcb_table[siopid].siopinib->BbbiRx) );
}

/*
 * ݂̃VA|[g̎擾
 */
ID
uart_get_id(SIOPCB *siopcb)
{
	return(siopcb->siopid);
}

