// Momiji.Test.MM.WaveOut.cpp : C vWFNg t@CłB

#include "stdafx.h"
#using <Momiji.Core.dll>

using namespace System;

void test1()
{
	System::UInt32 nums = Momiji::Core::Wave::Out::Device::GetNumDevices();
	Console::WriteLine("[{0}]", nums);

	Console::WriteLine("====================================================");
	for (System::UInt32 idx = 0; idx <= nums; idx++) {

		try
		{
			Momiji::Interop::Winmm::WaveOutCapabilities^ cap = 
				Momiji::Core::Wave::Out::Device::GetCapabilities(idx);

			Console::Write("[{0}]", idx);
			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0:f}]", cap->formats);
			Console::Write("[{0}]", cap->channels);
			Console::Write("[{0}]", cap->reserved1);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			Console::WriteLine("[{0}]", cap->manufacturerGuid);
			Console::WriteLine("[{0}]", cap->productGuid);
			Console::WriteLine("[{0}]", cap->nameGuid);
		}
		catch(Exception^ e)
		{
			Console::WriteLine(e->ToString());
		}
	}
}

void test2()
{
	try
	{
		System::UInt32 s = 48000;

		Momiji::Core::Wave::Out::Device^ out = 
			gcnew Momiji::Core::Wave::Out::Device(
				0,
				1,
				s,
				16
			);
		try
		{
			Momiji::Interop::Winmm::WaveOutCapabilities^ cap = out->GetCapabilities();

			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0}]", cap->formats);
			Console::Write("[{0}]", cap->channels);
			Console::Write("[{0}]", cap->reserved1);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			delete cap;

		//	out->open();

			System::GC::Collect();

			System::IO::Stream^ stream = gcnew System::IO::MemoryStream();
			System::IO::BinaryWriter^ writer = gcnew System::IO::BinaryWriter(stream);

			array<System::UInt32>^ l = 
				{
					s / (440),
					s / (440 + 40),
				//	s / (440 + 40 + 40),
					s / (440 + 40 + 40 + 40),
				//	s / (440 + 40 + 40 + 40 + 40),
					s / (440 + 40 + 40 + 40 + 40 + 40),
				//	s / (440 + 40 + 40 + 40 + 40 + 40 + 40),
					s / (440 + 40 + 40 + 40 + 40 + 40 + 40 + 40),
					s / (440 + 40 + 40 + 40 + 40 + 40 + 40 + 40 + 40 + 40),
				};

			for(auto idx = 0; idx < s * 2; idx++)
			{
				System::Int32 d = 0;

				for (auto j = 0; j < l->Length; j++)
				{
					if(idx % l[j] < l[j] / 2)
					{
						d += 8191;
					}
					else
					{
						d -= 8191;
					}
				}

				d = (d > System::Int16::MaxValue) ? System::Int16::MaxValue: d;
				d = (d < System::Int16::MinValue) ? System::Int16::MinValue: d;

				writer->Write(static_cast<System::Int16>(d));
			}
			stream->Position = 0;

			out->SendStream(stream);
			System::Console::ReadLine();

/*
			out->SendShort(0x00505090l);
			out->SendShort(0x00505590l);
			out->SendShort(0x00505890l);

			out->SendShort(0x00005090l);
			out->SendShort(0x00005590l);
			out->SendShort(0x00005890l);

			array<System::Byte>^ data = {0xF0,0x41,0x10,0x42,0x12,0x40,0x00,0x7F,0x00,0x41,0xF7};
			out->SendLong(data);
			out->SendLong(data);
			out->SendLong(data);
*/
		//	out->close();
		}
		finally
		{
			delete out;
		}
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

void test3()
{
	try
	{
		delete gcnew Momiji::Core::Wave::Out::Device(0,1,48000,16);
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

void test4()
{
	try
	{
		Console::WriteLine("======== Momiji::Core::WaveOut^ out1 = gcnew Momiji::Core::WaveOut(0)");
		Momiji::Core::Wave::Out::Device^ out1 = gcnew Momiji::Core::Wave::Out::Device(0,1,48000,16);

		{
			Console::WriteLine("======== Momiji::Core::WaveOut^ out2 = out1;");
			Momiji::Core::Wave::Out::Device^ out2 = out1;
		}
		Console::WriteLine("======== System::GC::Collect();");
		System::GC::Collect();
		System::GC::WaitForPendingFinalizers();
		System::GC::Collect();

		Console::WriteLine("======== Momiji::Core::WaveOut^ out3 = out1;");
		Momiji::Core::Wave::Out::Device^ out3 = out1;

		Console::WriteLine("======== delete out3;");
		delete out3;
		System::GC::Collect();
		System::GC::WaitForPendingFinalizers();
		System::GC::Collect();

		Console::WriteLine("======== delete out1;");
		delete out1;
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}


int main(array<System::String ^> ^args)
{
   	Console::WriteLine("====================================================test1");
	test1();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test2");
	test2();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test3");
	test3();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();
	
	Console::WriteLine("====================================================test4");
	test4();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================");
	System::Console::ReadLine();
    return 0;
}
