﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;

using Vintagestory.API.MathTools;

using ProtoBuf;

namespace Automap
{
	[ProtoContract]
	public struct ColumnMeta
	{
		[ProtoMember(1)]
		public Vec2i Location;

		[ProtoMember(2)]
		public TimeSpan ChunkAge;//In game, calendar?

		[ProtoMember(3)]
		public float Temperature;// Temperature

		[ProtoMember(4)]
		public ushort YMax;// Y feature height

		[ProtoMember(5)]
		public Dictionary<int,uint> RockRatio;//(surface) Geographic region (rock) Ratio. [BlockID * count]

		[ProtoMember(6)]
		public float Fertility;

		[ProtoMember(7)]
		public float ForestDensity;

		[ProtoMember(8)]
		public float Rainfall;

		[ProtoMember(9)]
		public float ShrubDensity;

		public ColumnMeta(Vec2i loc)
		{
		Location = loc;
		ChunkAge = TimeSpan.Zero;
		Temperature = 0f;
		YMax = 0;
		RockRatio = new Dictionary<int, uint>( 10 );
		Fertility = 0f;
		ForestDensity = 0f;
		Rainfall = 0f;
		ShrubDensity = 0f;
		}
	}

	public class ColumnsMetadata : KeyedCollection<Vec2i, ColumnMeta>
	{
		private ColumnsMetadata( )
		{
			throw new NotSupportedException();
		}

		public ColumnsMetadata(Vec2i startChunkColumn)
		{
		North_mostChunk = startChunkColumn.Y;
		South_mostChunk = startChunkColumn.Y;
		East_mostChunk = startChunkColumn.X;
		West_mostChunk = startChunkColumn.X;
		}

		public int North_mostChunk {
			get; private set;
		}

		public int South_mostChunk {
			get; private set;
		}

		public int East_mostChunk {
			get; private set;
		}

		public int West_mostChunk {
			get; private set;
		}

		protected override Vec2i GetKeyForItem(ColumnMeta item)
		{
		return item.Location;
		}

		internal void Update(ColumnMeta metaData)
		{
		if (this.Contains(metaData.Location)) {
		this.Remove(metaData.Location);
		this.Add(metaData);
		}
		else {
		this.Add(metaData);
		}

		}

		public new void Add(ColumnMeta newItem)
		{
		if (North_mostChunk > newItem.Location.Y) {
		North_mostChunk = newItem.Location.Y;
		}

		if (South_mostChunk < newItem.Location.Y) {
		South_mostChunk = newItem.Location.Y;
		}

		if (East_mostChunk < newItem.Location.X) {
		East_mostChunk = newItem.Location.X;
		}

		if (West_mostChunk > newItem.Location.X) {
		West_mostChunk = newItem.Location.X;
		}

		base.Add(newItem);
		}

	}
}

