﻿using System;
using System.Collections.ObjectModel;

using ProtoBuf;

using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.API.Util;

namespace AdminToolkit
{
	public class BannerControl : AdminModCommand
	{
		private const string _bannerDataKey = @"banners";

		private BannerList Banners { get; set; }

		/// <summary>
		/// Control and Configuration of automatic Broadcast 'banners' / M.O.T.H.
		/// </summary>
		public BannerControl(ICoreServerAPI _serverAPI) : base(_serverAPI)
		{

		//Add <slot#> <repeat/once> <DD:HH:MM:SS> "text"
		//Remove <slot#>
		//Replace <slot#> "text"
		//List

		//Mode:
		//Repeating (Per unit of time), Once (Future-Date)

		//Delay - Relative event time;
		//HH:MM:SS
		ServerAPI.Event.ServerRunPhase(EnumServerRunPhase.RunGame, ReactivateBanners);

		this.Command = "banners";
		this.Description = "Control future broadcast 'banners' & repeating Messages";
		this.RequiredPrivilege = Privilege.announce;
		this.Syntax = @"Add / Remove / Replace / List";
		this.handler += HandleBannerCommand;
		}

		private void ReactivateBanners( )
		{
		var bannerBytes = ServerAPI.WorldManager.SaveGame.GetData(_bannerDataKey);

		if (bannerBytes != null) {
		this.Banners = SerializerUtil.Deserialize<BannerList>(bannerBytes);
		Logger.Notification("Loaded Banners Data; ({0})", Banners.Count);
		}
		else {
		BannerList emptyBannerList = new BannerList( );

		var emptybannerListBytes = SerializerUtil.Serialize<BannerList>(emptyBannerList);

		ServerAPI.WorldManager.SaveGame.StoreData(_bannerDataKey, emptybannerListBytes);

		this.Banners = emptyBannerList;
		Logger.Notification("Created (empty) Banners Data");
		}


		}


		private void HandleBannerCommand(IServerPlayer player, int groupId, CmdArgs args)
		{
			
		if (args.Length >= 1) {
		string cmd = args.PopWord(string.Empty);
		switch (cmd.ToLowerInvariant()) 
		{
		//Add <slot#> <repeat/once> <DD:HH:MM:SS> "text"
		//Remove <slot#>
		//Replace <slot#> "text"
		//List
		case "add":

		break;

		case "remove":

		break;

		case "replace":

		break;

		case "list":

		break;

		default:
		player.SendMessage(groupId, "Unrecognised command ", EnumChatType.CommandError);
		break;

		}
		}
		else {
		player.SendMessage(groupId, "Supply a command verb", EnumChatType.CommandError);
		}

		}

		[ProtoContract]
		public struct BannerEntry
		{
			[ProtoMember(1)]
			public byte Entry;

			[ProtoMember(2)]
			public string Message;

			[ProtoMember(3)]
			public TimeSpan EventTime;//Delay between tick events

			[ProtoMember(4)]
			public bool Repeat;//Self Re-register on execution of tick event
		}

		[ProtoContract]
		public class BannerList : KeyedCollection<byte, BannerEntry>
		{
			protected override byte GetKeyForItem(BannerEntry item)
			{
			return item.Entry;
			}

			public void Append(BannerEntry banner)
			{
			banner.Entry = ( byte )this.Count;
			Add(banner);
			}

			private new void Add(BannerEntry item)
			{
				//Not directly.
			}
		}
	}
}

