#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.88dsf
TARGET=sysvinit-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Making...
make -C src fstab-decode \
	1> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1
make -C src killall5 \
	1>> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1
make -C src last \
	1>> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
cp -v src/{fstab-decode,killall5} /sbin" \
	1> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv ../sbin/killall5 /bin/pidof" \
	1>> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v src/last /usr/bin" \
	1>> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sv last /usr/bin/lastb" \
	1>> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v man/{last,lastb}.1 /usr/share/man/man1" \
	1>> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v man/{fstab-decode,killall5,pidof}.8 /usr/share/man/man8" \
	1>> $LOG/$CHAP.$TARGET.2_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

