#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=1.15.5
TARGET=kbd-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Patching...
#patch -Np1 -i $DLD/kbd-$VER-upstream_fixes-1.patch \
#	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/kbd-$VER-backspace-1.patch \
	1>> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i -e '326 s/if/while/' src/loadkeys.analyze.l

echo \ \ Configuring...
./configure --prefix=/usr --datadir=/lib/kbd \
	--disable-vlock \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/{kbd_mode,loadkeys,openvt,setfont} /bin"

mkdir -v /usr/share/doc/kbd-$VER
paco -p+ $TARGET "cp -R -v doc/* \
         /usr/share/doc/kbd-$VER"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

