#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=0.18.2
TARGET=gettext-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i -e '/gets is a/d' gettext-*/*/stdio.in.h

echo \ \ Configuring...
cd gettext-tools
EMACS="no" ./configure --prefix=/tools --disable-shared \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make -C gnulib-lib \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Making...
make -C src msgfmt \
	1> $LOG/$CHAP.$TARGET.3_make.log 2>&1 || exit 1
make -C src msgmerge \
	1>> $LOG/$CHAP.$TARGET.3_make.log 2>&1 || exit 1
make -C src xgettext \
	1>> $LOG/$CHAP.$TARGET.3_make.log 2>&1 || exit 1

cp -v src/{msgfmt,msgmerge,xgettext} /tools/bin

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

echo \ \ Done.

