#/bin/sh

CHAP=6
APPNAME=binutils
VER=2.25
TARGET=$APPNAME-$VER
TARGETBALL=${TARGET}.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr binutils-build

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir ../binutils-build
cd ../binutils-build

echo \ \ Configuring...
../binutils-$VER/configure --prefix=/usr \
                           --enable-shared \
                           --disable-werror \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make tooldir=/usr \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make tooldir=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR
rm -fr binutils-build

echo \ \ Done.

