#/bin/sh

CHAP=5
TARGET=strip

. ./_lfsset.sh

echo $TARGET

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Stripping...
strip --strip-debug /tools/lib/* \
	1> $LOG/$CHAP.$TARGET.1_strip.log 2>&1

/usr/bin/strip --strip-unneeded /tools/{,s}bin/* \
	1> $LOG/$CHAP.$TARGET.2_strip.log 2>&1

echo \ \ Removing...
rm -rf /tools/{,share}/{info,man,doc} \
	1> $LOG/$CHAP.$TARGET.3_strip.log 2>&1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/_lfstime.txt

echo \ \ Done.

