#/bin/sh

CHAP=5
APPNAME=glibc
VER=2.20
KERNELVER=2.6.32
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr glibc-build

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

if [ ! -r /usr/include/rpc/types.h ]; then
  su -c 'mkdir -pv /usr/include/rpc'
  su -c 'cp -v sunrpc/rpc/*.h /usr/include/rpc'
fi

mkdir ../glibc-build
cd ../glibc-build

echo \ \ Configuring...
../glibc-$VER/configure                             \
      --prefix=/tools                               \
      --host=$LFS_TGT                               \
      --build=$(../glibc-$VER/scripts/config.guess) \
      --disable-profile                             \
      --enable-kernel=$KERNELVER                    \
      --with-headers=/tools/include                 \
      libc_cv_forced_unwind=yes                     \
      libc_cv_ctors_header=yes                      \
      libc_cv_c_cleanup=yes                         \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo 'main(){}' > dummy.c
$LFS_TGT-gcc dummy.c
readelf -l a.out | grep ': /tools'
rm dummy.c a.out

TimeEnd chap5

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr glibc-build

echo \ \ Done.

