#/bin/sh

CHAP=5
APPNAME=expect
VER=5.45
TARGET=$APPNAME$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

cp configure{,.orig}
sed 's:/usr/local/bin:/bin:' configure.orig > configure

echo \ \ Configuring...
./configure --prefix=/tools       \
            --with-tcl=/tools/lib \
            --with-tclinclude=/tools/include \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make SCRIPTS="" install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap5

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

