#/bin/sh

. ./_clfsset.sh

echo Configuring the system hostname

echo "CLFS" > /etc/hostname

echo Customizing the /etc/hosts File 

cat > /etc/hosts << "EOF"
# Begin /etc/hosts (network card version)

127.0.0.1 localhost
192.168.11.95 CLFS

# End /etc/hosts (network card version)
EOF

echo Creating the /etc/resolv.conf File

cat > /etc/resolv.conf << "EOF"
# Begin /etc/resolv.conf

domain localdomain

# End /etc/resolv.conf
EOF

echo CLFS-Network-Scripts-20140224

APPNAME=boot-scripts-cross-lfs
VER=3.0-20140710
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET
RemoveSrcDir
. $WRK/_extract.sh
TimeStart
cd $TARGETDIR

echo Installing...
make install \
        1> $LOG/$APPNAME.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
echo Done.

APPNAME=dhcpcd
VER=6.3.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC
echo $TARGET
RemoveSrcDir
. $WRK/_extract.sh
TimeStart
cd $TARGETDIR
echo Configuring...
#CC="gcc ${BUILD64}"
CC="gcc" \
./configure --prefix=/usr --sbindir=/sbin \
    --sysconfdir=/etc --dbdir=/var/lib/dhcpcd --libexecdir=/usr/lib64/dhcpcd \
    --libdir=/usr/lib64 \
        1> $LOG/$APPNAME.1_conf.log 2>&1 || exit 1
echo Making...
make \
        1> $LOG/$APPNAME.2_make.log 2>&1 || exit 1
echo Installing...
make install \
        1> $LOG/$APPNAME.3_install.log 2>&1 || exit 1
TimeEnd
cd ..
RemoveSrcDir
echo Done.
cd /etc &&
cat > dhcpcd.conf << "EOF"
# dhcpcd configuration eth0 interface
# See dhcpcd.conf(5) for details.

interface eth0
# dhcpcd-run-hooks uses these options.
option subnet_mask, routers, domain_name_servers

# The default timeout for waiting for a DHCP response is 30 seconds
# which may be too long or too short and can be changed here.
timeout 16
EOF

