#/bin/sh

. ./_clfsset.sh

APPNAME=systemd
VER=213
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/systemd-$VER-compat-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

sed -i '/virt-install-hook /d' Makefile.in
sed -i '/timesyncd.conf/d' src/timesync/timesyncd.conf.in
sed -i '/-l/d' src/fsck/fsck.c

echo Configuring...
CC="gcc ${BUILD64}" PKG_CONFIG_PATH="${PKG_CONFIG_PATH64}" \
  ./configure --prefix=/usr \
    --sysconfdir=/etc --localstatedir=/var --libdir=/usr/lib64 \
    --libexecdir=/usr/lib64 --docdir=/usr/share/doc/systemd-213 \
    --with-rootprefix="" -with-rootlibdir=/lib64 \
    --enable-split-usr --disable-gudev --with-kbd-loadkeys=/bin/loadkeys \
    --with-kbd-setfont=/bin/setfont --with-dbuspolicydir=/etc/dbus-1/system.d \
    --with-dbusinterfacedir=/usr/share/dbus-1/interfaces \
    --with-dbussessionservicedir=/usr/share/dbus-1/services \
    --with-dbussystemservicedir=/usr/share/dbus-1/system-services \
    cc_cv_CFLAGS__flto=no \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

sed -e "s:test/udev-test.pl::g" \
    -e "s:test-bus-cleanup\$(EXEEXT) ::g" \
    -e "s:test-bus-gvariant\$(EXEEXT) ::g" \
    -i Makefile

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

install -v -m644 man/*.html /usr/share/doc/systemd-213 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/lib64/libnss_myhostname.so.2 /lib64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

rm -rfv /usr/lib/rpm \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

for tool in runlevel reboot shutdown poweroff halt telinit; do
  ln -sfv ../bin/systemctl /sbin/$tool \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
done
ln -sfv ../lib/systemd/systemd /sbin/init \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

sed -i "s@root lock@root root@g" /usr/lib/tmpfiles.d/legacy.conf \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

systemd-machine-id-setup \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

cat > /etc/os-release << "EOF"
# Begin /etc/os-release

NAME=Cross-LFS
ID=clfs

PRETTY_NAME=Cross Linux From Scratch
ANSI_COLOR=0;33

VERSION=3.0.0-SYSTEMD
VERSION_ID=20141018

# End /etc/os-release
EOF
touch /etc/os-release \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
