#/bin/sh

. ./_clfsset.sh

APPNAME=readline
VER=6.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/readline-$VER-branch_update-4.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
   ./configure --prefix=/usr --libdir=/lib \
    --docdir=/usr/share/doc/readline-$VER \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make SHLIB_LIBS=-lncurses \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make SHLIB_LIBS=-lncurses htmldir=/usr/share/doc/readline-6.3 install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /lib/lib{readline,history}.a /usr/lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

ln -svf ../../lib/$(readlink /lib/libreadline.so) /usr/lib/libreadline.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -svf ../../lib/$(readlink /lib/libhistory.so) /usr/lib/libhistory.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /lib/lib{readline,history}.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
