#/bin/sh

. ./_clfsset.sh

APPNAME=mpfr
VER=3.1.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/mpfr-3.1.2-fixes-4.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
    LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64 ${BUILD64}" \
    ./configure --prefix=/usr --libdir=/usr/lib64 \
    --docdir=/usr/share/doc/mpfr-3.1.2 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

