#/bin/sh

. ./_clfsset.sh

APPNAME=iproute2
VER=3.14.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i '/^TARGETS/s@arpd@@g' misc/Makefile
sed -i '/ARPD/d' Makefile
sed -i 's/arpd.8//' man/man8/Makefile

echo Patching...
patch -Np1 -i $DLD/iproute2-$VER-libdir-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Making...
make CC="gcc ${BUILD64}" LIBDIR=/usr/lib64 \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make LIBDIR=/usr/lib64 \
    DOCDIR=/usr/share/doc/iproute2-$VER install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
