#/bin/sh

. ./_cblfsset.sh

APPNAME=porg
VER=0.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  \
	gtkmm bash-completion
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" PKG_CONFIG_PATH="${PKG_CONFIG_PATH32}" \
    ./configure --prefix=/usr --sysconfdir=/etc \
        $([ ${OPTION_gtkmm} -ne 1 ] && echo --disable-grop) \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
make logme \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" PKG_CONFIG_PATH="${PKG_CONFIG_PATH64}" \
    ./configure --prefix=/usr --sysconfdir=/etc --libdir=/usr/lib64 \
        $([ ${OPTION_gtkmm} -ne 1 ] && echo --disable-grop) \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
make logme \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

#cp -v scripts/paco_bash_completion /etc/bash_completion.d/ \
#        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PorgingDone

