#/bin/sh

. ./_cblfsset.sh

APPNAME=pcre
VER=8.32
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStr

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
./configure --prefix=/usr --enable-utf8 --enable-unicode-properties \
    --enable-pcregrep-libz  --enable-pcregrep-libbz2 \
    --enable-pcretest-libreadline \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/pcre-config{,-32}" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

BIT64
cd ..
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" ./configure \
--prefix=/usr --libdir=/usr/lib64 \
    --enable-utf8 --enable-unicode-properties \
    --enable-pcregrep-libz  --enable-pcregrep-libbz2 \
    --enable-pcretest-libreadline \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/pcre-config{,-64}" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -s multiarch_wrapper /usr/bin/pcre-config" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

