#/bin/sh

. ./_cblfsset.sh

APPNAME=net-tools
VER=1.60
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/net-tools-$VER-gcc34-3.patch \
	1> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/net-tools-$VER-kernel_headers-4.patch \
	1>> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/net-tools-$VER-mii_ioctl-1.patch \
	1>> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/net-tools-$VER-supress_hostname-1.patch \
	1>> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1

echo Configuring...
yes "" | make config \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

sed -i -e 's|HAVE_IP_TOOLS 0|HAVE_IP_TOOLS 1|g' \
       -e 's|HAVE_MII 0|HAVE_MII 1|g' config.h &&
sed -i -e 's|# HAVE_IP_TOOLS=0|HAVE_IP_TOOLS=1|g' \
       -e 's|# HAVE_MII=0|HAVE_MII=1|g' config.make

echo Making...
make CC="gcc ${BUILD64}" \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make update" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

