#!/bin/sh

APPNAME=w3m
VER=0.5.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_blfsset.sh

echo $TARGET

echo Check Required...
./_checkRequired.sh gc || exit 1

echo Check Options...
. ./_checkOptions.sh nkf gpm openssl imlib2 gtk+-2 buggy gdk-pixbuf compface

echo -n Tarball $TARGETBALL" "
if [ -e $DLD/$TARGETBALL ]; then
  echo  found
else
  echo  not found && exit 1
fi

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

#echo \ \ Patching unofficial...
#patch -Np1 -i $WRK/patch/w3m-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo \ \ Patching...
patch -Np1 -i $DLD/w3m-$VER-bdwgc72-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's/file_handle/file_foo/' istream.{c,h}
sed -i 's#gdk-pixbuf-xlib-2.0#& x11#' configure

echo \ \ Configuring...
./configure --prefix=/usr \
            --sysconfdir=/etc \
	    --libexecdir=/usr/lib \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 -D doc/keymap.default /etc/w3m/keymap" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644    doc/menu.default /etc/w3m/menu" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/w3m-$VER
paco -p+ $TARGET "\
install -v -m644    doc/{HISTORY,READ*,keymap.*,menu.*,*.html} \
                    /usr/share/doc/w3m-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

