#/bin/sh

. ./_blfsset.sh

APPNAME=eudev
VER=2.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2
. $WRK/_checkOptions.sh  \
	gobject-introspection docbook-xsl libxslt \
	gtk-doc pciutils usbutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -r -i 's|/usr(/bin/test)|\1|'         test/udev-test.pl

Configuring
./configure --prefix=/usr           \
            --bindir=/sbin          \
            --sbindir=/sbin         \
            --libdir=/usr/lib       \
            --sysconfdir=/etc       \
            --libexecdir=/lib       \
            --with-rootprefix=      \
            --with-rootlibdir=/lib  \
            --enable-split-usr      \
            --enable-libkmod        \
            --enable-rule_generator \
            --enable-keymap         \
$([ ${OPTION_gobjectintrospection} -ne 1 ] && echo --disable-introspection) \
            --disable-gtk-doc-html  \
            --with-firmware-path=/lib/firmware \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make  \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

