#!/bin/sh

. ./_blfsset.sh

APPNAME=Trac
VER=1.0.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	python setuptools
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Compiling catalog...
python ./setup.py compile_catalog -f \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
python ./setup.py compile_catalog -f \
	1> $LOG/$TARGET.3_install.log 2>&1 
porg -lp+ $TARGET "python ./setup.py install" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

