#!/bin/sh

. ./_blfsset.sh

APPNAME=tcp-wrappers
VER=7.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/tcp-wrappers_7.6-ipv6.1.orig.tar.gz
TARGETDIR=tcp_wrappers_7.6-ipv6.1

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
#patch -Np1 -i $DLD/tcp_wrappers-7.6-shared_lib_plus_plus-1.patch \
#	1> $LOG/$TARGET.1_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/tcp_wrappers-7.6-ipv6-1.patch \
	1> $LOG/$TARGET.1_patch.log 2>&1 || exit 1

sed -i -e "s,^extern char \*malloc();,/* & */," scaffold.c
sed -i "s/ln -s/ln -sf/" Makefile

Making
make \
	REAL_DAEMON_DIR=/usr/sbin \
	STYLE=-DPROCESS_OPTIONS linux \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  tcp_wrappers-$VER "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone tcp_wrappers-$VER

