#!/bin/sh

. ./_blfsset.sh

APPNAME=tcl
VER=8.6.3
VER2=8.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}$VER-src.tar.gz
TARGETDIR=${APPNAME}$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

SRCDIR=`pwd`

Configuring
cd unix &&
./configure --prefix=/usr \
            --without-tzdata \
            --mandir=/usr/share/man \
	    $([ $(uname -m) = x86_64 ] && echo --enable-64bit) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed -e "s#$SRCDIR/unix#/usr/lib#" \
    -e "s#$SRCDIR#/usr/include#"  \
    -i tclConfig.sh \

sed -e "s#$SRCDIR/unix/pkgs/tdbc1.0.2#/usr/lib/tdbc1.0.2#" \
    -e "s#$SRCDIR/pkgs/tdbc1.0.2/generic#/usr/include#"    \
    -e "s#$SRCDIR/pkgs/tdbc1.0.2/library#/usr/lib/tcl8.6#" \
    -e "s#$SRCDIR/pkgs/tdbc1.0.2#/usr/include#"            \
    -i pkgs/tdbc1.0.2/tdbcConfig.sh

sed -e "s#$SRCDIR/unix/pkgs/itcl4.0.2#/usr/lib/itcl4.0.2#" \
    -e "s#$SRCDIR/pkgs/itcl4.0.2/generic#/usr/include#"    \
    -e "s#$SRCDIR/pkgs/itcl4.0.2#/usr/include#"            \
    -i pkgs/itcl4.0.2/itclConfig.sh

unset SRCDIR

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "make install-private-headers" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "ln -v -sf tclsh${VER2} /usr/bin/tclsh" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libtcl${VER2}.so \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

