#!/bin/sh

. ./_blfsset.sh

APPNAME=strigi
VER=0.7.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-$VER.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake expat
. $WRK/_checkOptions.sh  \
	dbus qt-4 ffmpeg exiv2 clucene log4cxx
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i "s|BufferedStream :|STREAMS_EXPORT &|" libstreams/include/strigi/bufferedstream.h

mkdir build
cd    build 

# -DCLUCENE1_LDFLAGS="clucene-shared" \
echo Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=/usr \
      -DCMAKE_INSTALL_LIBDIR=lib  \
      -DCMAKE_BUILD_TYPE=Release  \
      .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

