#!/bin/sh

APPNAME=ppp
VER=2.4.5
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_blfsset.sh

echo Check Required...
./_checkRequired.sh || exit 1

echo Check Options...
. ./_checkOptions.sh libpcap Linux-PAM

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

groupadd -g 52 pppusers

echo \ \ Configuring...
rm include/linux/if_pppol2tp.h
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "install -d /etc/ppp/peers" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

