#!/bin/sh

. ./_blfsset.sh

APPNAME=pinentry
VER=0.8.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	gtk+-2 qt-4 libcap2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_gtk2} -eq "1" ]; then
  export DISABLEGTK=""
else
  export DISABLEGTK="--disable-pinentry-gtk --disable-pinentry-gtk2 "
fi
if [ ${OPTION_qt4} -eq "1" ]; then
  export DISABLEQT=""
else
  export DISABLEQT="--disable-pinentry-qt "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	$DISABLEGTK $DISABLEQT \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

