#!/bin/sh

. ./_blfsset.sh

APPNAME=mono
VER=3.2.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libgdiplus
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

if [ ${OPTION_libgdiplus} -eq "1" ]; then
  export WITHLIBGDIPLUS="--with-libgdiplus=installed "
else
  export WITHLIBGDIPLUS="--with-libgdiplus=sibling --without-x "
fi

Configuring
./configure --prefix=/usr \
	$WITHLIBGDIPLUS \
	--with-libgdiplus=installed \
	--with-profile4=yes \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

