#!/bin/sh

. ./_blfsset.sh

APPNAME=lynx
VER=2.8.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/lynx2.8.8dev.14.tar.bz2
TARGETDIR=lynx2-8-8

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openssl gnutls zip unzip sharutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr          \
            --sysconfdir=/etc/lynx \
            --datadir=/usr/share/doc/lynx-2.8.8dev.14 \
            --with-zlib            \
            --with-bzlib           \
            --with-screen=ncursesw \
            --enable-locale-charset \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
	make install-full" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
chgrp -v -R root /usr/share/doc/lynx-2.8.8dev.14/lynx_doc" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

sed -i 's/#\(LOCALE_CHARSET\):FALSE/\1:TRUE/' /etc/lynx/lynx.cfg
sed -i 's/#\(DEFAULT_EDITOR\):/\1:vi/' /etc/lynx/lynx.cfg
sed -i 's/#\(PERSISTENT_COOKIES\):FALSE/\1:TRUE/' /etc/lynx/lynx.cfg

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

