#!/bin/sh

. ../_blfsset.sh
. ./_lxdeset.sh

APPNAME=lxsession
VER=0.4.9.2
TARGET=$APPNAME-$VER
TARGETBALL=$LXDEDLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus-glib gtk+-2 libgee polkit vala
. $WRK/_checkOptions.sh  \
	libxslt docbook-xml docbook-xsl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --enable-man=yes \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

