#!/bin/sh

. ./_blfsset.sh

APPNAME=libmad
VER=0.15.1b
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/libmad-0.15.1b-fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed "s@AM_CONFIG_HEADER@AC_CONFIG_HEADERS@g" -i configure.ac
touch NEWS AUTHORS ChangeLog

echo Autoreconfing...
autoreconf -fi \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /usr/lib/pkgconfig/mad.pc << "EOF"
prefix=/usr
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
includedir=${prefix}/include

Name: mad
Description: MPEG audio decoder
Requires:
Version: 0.15.1b
Libs: -L${libdir} -lmad
Cflags: -I${includedir}
EOF

paco -p+ $TARGET "\
touch /usr/lib/pkgconfig/mad.pc"

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

