#!/bin/sh

. ./_blfsset.sh

APPNAME=libcap2
APPNAME2=libcap
VER=2.24
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME2-$VER.tar.xz
TARGETDIR=$APPNAME2-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	Linux-PAM
. $WRK/_checkOptions.sh
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's:LIBDIR:PAM_&:g' pam_cap/Makefile

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed -i '/install.*STALIBNAME/ s/^/#/' libcap/Makefile

Installing
porg -lp $TARGET "\
make prefix=/usr \
     SBINDIR=/sbin \
     PAM_LIBDIR=/lib \
     RAISE_SETFCAP=no install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /usr/lib/libcap.so \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/lib/libcap.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/libcap.so.2 /usr/lib/libcap.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

