#!/bin/sh

. ../_blfsset.sh
. ./_kdeset.sh

VER=4.9.1
TARGET=kde-runtime-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo Check Required...
../_checkRequired.sh kdelibs libtirpc \
	|| exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/kde-runtime-$VER-rpc_fix-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd build

echo \ \ Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=$KDE_PREFIX \
      -DSYSCONF_INSTALL_DIR=/etc/kde \
      .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

