#!/bin/sh

. ./_blfsset.sh

APPNAME=imlib2
VER=1.4.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	freetype
. $WRK/_checkOptions.sh  \
	libpng libjpeg-turbo \
	Xorg-lib-libX11 tiff giflib libid3tag
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_LinuxPAM} -eq "1" ]; then
#  export WITHPAM=""
#else
#  export WITHPAM="--without-pam "
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i "/DGifOpen/s:fd:&, NULL:" src/modules/loaders/loader_gif.c
sed -i 's/@my_libs@//' imlib2-config.in

Configuring
./configure --prefix=/usr --disable-static \
$([ ${OPTION_XorgliblibX11} -ne 1 ] && echo --without-x) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/imlib2-$VER

paco -p+ $TARGET "\
install -v -m644    doc/{*.gif,index.html} \
                    /usr/share/doc/imlib2-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

