#!/bin/sh

. ./_blfsset.sh

APPNAME=gnupg
APPVER=1
VER=1.4.12
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
./_checkRequired.sh || exit 1

echo Check Options...
. ./_checkOptions.sh openldap libusb-compat curl sendmail docbook-to-man

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr --libexecdir=/usr/lib \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/gnupg-$VER

paco -p+ $TARGET "\
mv -v /usr/share/gnupg/FAQ /usr/share/doc/gnupg-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 \
    doc/{highlights-1.4.txt,OpenPGP,samplekeys.asc,DETAILS,*.texi} \
    /usr/share/doc/gnupg-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME$APPVER.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none
 
echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

